% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{aurora_queries}
\alias{aurora_queries}
\title{SDG queries of the Aurora Universities Network}
\format{
A data frame with 378 rows and 5 columns
\describe{
  \item{system}{Name of system}
  \item{sdg}{Label of the SDG}
  \item{sdg_title}{Title of the SDG}
  \item{sdg_description}{Description of the SDG}
  \item{query_id}{Index of the query}
  \item{query}{Original SDG query}
}
}
\source{
\url{https://github.com/Aurora-Network-Global/sdg-queries/releases/tag/v5.0}
}
\usage{
aurora_queries
}
\description{
A dataset containing the SDG queries version 5.0 of the \href{https://aurora-universities.eu/}{Aurora Universities Network}. See the corresponding \href{https://github.com/Aurora-Network-Global/sdg-queries}{GitHub repository}. For the actual implementation of the queries see \code{aurora_simple}, \code{aurora_and}, \code{aurora_w}, and the queries hard-coded in \code{detect_aurora}. There are multiple queries per SDG (one per row). In comparison to previous versions, this version of the queries Aurora added more keywords related to academic terminology to be able to detect more research papers related to the SDGs. The current version also drew inspiration from the SIRIS query system (\code{siris_queries}). The Aurora queries were designed to be precise rather than sensitive. To achieve this the queries make use complex keyword-combinations using several different logical search operators. All SDGs (1-17) are covered.
}
\keyword{datasets}
