% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_5_textTrainPredictExamples.R
\name{textExamples}
\alias{textExamples}
\title{Identify language examples.}
\usage{
textExamples(
  text,
  x_variable,
  y_variable = NULL,
  type = "default",
  n_tile = 4,
  n_examples = 5,
  jitter = NULL,
  filter_words = NULL,
  target_color = "darkgreen",
  predictions_color = "darkblue",
  error_color = "darkred",
  distribution_color = c("#00508c", "#805259", "#a71200", "#0a6882", "#a4a4a4",
    "#e04b39", "#19956e", "#22a567", "#5c8a59"),
  figure_format = "svg",
  scatter_legend_dot_size = 3,
  scatter_legend_bg_dot_size = 2,
  scatter_legend_dots_alpha = 0.8,
  scatter_legend_bg_dots_alpha = 0.2,
  scatter_show_axis_values = TRUE,
  scatter_legend_regression_line_colour = NULL,
  x_axis_range = NULL,
  y_axis_range = NULL,
  grid_legend_x_axes_label = NULL,
  grid_legend_y_axes_label = NULL,
  grid_legend_title = NULL,
  grid_legend_number_size = 8,
  grid_legend_number_color = "white",
  grid_legend_title_color = "black",
  grid_legend_title_size = 0,
  seed = 42
)
}
\arguments{
\item{text}{(string) the language that was used for prediction/assessment/classification.}

\item{x_variable}{(numeric) the variable used for training (y).}

\item{y_variable}{(numeric) the outcome from the model (i.e., y_hat).}

\item{type}{(string) If you are plotting errors between predicted and targeted scores, you can set the type to "prediction_errors",
to produce two extra plots: distribution of scores and absolute error.}

\item{n_tile}{(integer) the n tile to split the data in (to show the most extreme tiles in different colours).}

\item{n_examples}{(integer) the number of language examples to show/select in each quadrant.
When providing both x_variable and y_variable, each example is categorized into one of nine bivariate quadrants
based on its position in the scatterplot (e.g., low–low, high–high, center).
Within each quadrant, the function selects the most extreme examples by computing the distance to that quadrant’s corner:
Corner quadrants (1, 3, 7, 9):
Examples closest to the corner points (e.g., min x & max y) are selected using Euclidean distance.
Edge quadrants (2, 4, 6, 8):
Examples furthest along the relevant axis (x or y) are selected.
Center quadrant (5):
Examples closest to the mean of both x and y are selected.}

\item{jitter}{(integer) the percentage of jitter to add to the data for the scatter plot.}

\item{filter_words}{(character vector) words required to be included in examples.}

\item{target_color}{(string)}

\item{predictions_color}{(string) = "darkblue",}

\item{error_color}{=  (string) "darkred",}

\item{distribution_color}{(string) colors of the distribution plot}

\item{figure_format}{(string) file format of the figures.}

\item{scatter_legend_dot_size}{(integer) The size of highlighted dots in the scatter legend.}

\item{scatter_legend_bg_dot_size}{(integer) The size of background dots in the scatter legend.}

\item{scatter_legend_dots_alpha}{(numeric) The transparency alphe level of the dots.}

\item{scatter_legend_bg_dots_alpha}{(numeric) The transparency alphe level of the background dots.
For example: c(1,0,1) result in one dot in each quadrant except for the middle quadrant.}

\item{scatter_show_axis_values}{(boolean) If TRUE, the estimate values are shown on the distribution plot axes.}

\item{scatter_legend_regression_line_colour}{(string) If a colour string is added, a regression line will be plotted.}

\item{x_axis_range}{(numeric vector) range of x axis (e.g., c(1, 100)).}

\item{y_axis_range}{(numeric vector) range of y axis (e.g., c(1, 100)).}

\item{grid_legend_x_axes_label}{(string) x-axis label of the grid topic plot.}

\item{grid_legend_y_axes_label}{(string) y-axis label of the grid topic plot.}

\item{grid_legend_title}{(string)}

\item{grid_legend_number_size}{(integer)}

\item{grid_legend_number_color}{(string)}

\item{grid_legend_title_color}{(string)}

\item{grid_legend_title_size}{(integer)}

\item{seed}{(integer) The seed to set for reproducibility.}
}
\value{
A tibble including examples with descriptive variables.
}
\description{
This function identifies examples based on the frequency of use of n-grams (see the topics-pacakge),
estimated topic prevalence (see the topics-pacakge), or  assessment scores from textTrain() or textPredict().
}
