% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_0_1_text_initialize.R
\name{textrpp_initialize}
\alias{textrpp_initialize}
\title{Initialize text required python packages}
\usage{
textrpp_initialize(
  python_executable = NULL,
  virtualenv = NULL,
  condaenv = "textrpp_condaenv",
  ask = FALSE,
  refresh_settings = FALSE,
  save_profile = FALSE,
  check_env = TRUE,
  textEmbed_test = FALSE
)
}
\arguments{
\item{python_executable}{the full path to the Python executable, for which
text required python packages is installed.}

\item{virtualenv}{set a path to the Python virtual environment with text required python packages
installed Example: \code{virtualenv = "~/myenv"}}

\item{condaenv}{set a path to the anaconda virtual environment with text required python packages
installed Example: \code{condalenv = "myenv"}}

\item{ask}{logical; if \code{FALSE}, use the first text required python packages installation found;
if \code{TRUE}, list available text required python packages installations and prompt the user for
which to use. If another (e.g. \code{python_executable}) is set, then this
value will always be treated as \code{FALSE}.}

\item{refresh_settings}{logical; if \code{TRUE}, text will ignore the saved
settings in the profile and initiate a search of new settings.}

\item{save_profile}{logical; if \code{TRUE}, the current text required python packages setting will
be saved for the future use.}

\item{check_env}{logical; check whether conda/virtual environment generated
by \code{textrpp_install()} exists}

\item{textEmbed_test}{logical; Test whether function (textEmbed) that requires python packages works.}
}
\description{
Initialize text required python packages to call from R.
}
