% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3_1_textSimilarity.R
\name{textSimilarityNorm}
\alias{textSimilarityNorm}
\title{Compute the semantic similarity between a text variable and a word norm
(i.e., a text represented by one word embedding that represent a construct).}
\usage{
textSimilarityNorm(x, y)
}
\arguments{
\item{x}{Word embeddings from textEmbed (with several rows of text).}

\item{y}{Word embedding from textEmbed (from only one text).}
}
\value{
A vector comprising cosine semantic similarity scores.
}
\description{
Compute the semantic similarity between a text variable and a word norm
(i.e., a text represented by one word embedding that represent a construct).
}
\examples{
\dontrun{
library(dplyr)
library(tibble)
harmonynorm <- c("harmony peace ")
satisfactionnorm <- c("satisfaction achievement")

norms <- tibble::tibble(harmonynorm, satisfactionnorm)
wordembeddings <- wordembeddings4
wordembeddings_wordnorm <- textEmbed(norms)
similarity_scores <- textSimilarityNorm(
  wordembeddings$harmonytext,
  wordembeddings_wordnorm$harmonynorm
)
}
}
\seealso{
see \code{\link{textSimilarity}} and \code{\link{textSimilarityTest}}
}
