% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/degp3.R, R/pegp3.R, R/regp3.R
\name{degp3}
\alias{degp3}
\alias{pegp3}
\alias{regp3}
\title{Density, cumulative density, quantiles and random number generation for the
extended generalized Pareto distribution 3}
\usage{
degp3(x, kappa = 1, sigma, xi, u = 0, log.d = FALSE)

pegp3(q, kappa = 1, sigma, xi, u = 0, lower.tail = TRUE, log.p = FALSE)

regp3(n, kappa = 1, sigma, xi, u = 0)
}
\arguments{
\item{x, q, p}{Value, quantile or probability respectively.}

\item{kappa}{The power parameter (Papastathopoulos and Tawn call it the
shape parameter and call what we call the shape parameter the tail index.)}

\item{sigma}{Scale parameter.}

\item{xi}{Shape parameter.}

\item{u}{Threshold}

\item{log.d, log.p}{Whether or not to work on the log scale.}

\item{lower.tail}{Whether to return the lower tail.}

\item{n}{Number of random numbers to simulate.}
}
\description{
Density, cumulative density, quantiles and random number generation for the
EGP3 distribution of Papastathopoulos and Tawn
}
\examples{

  x <- regp3(1000, kappa=2, sigma=1, xi=.5)
  hist(x)
  x <- regp3(1000, kappa=2, sigma=exp(rnorm(1000, 1, .25)), xi=rnorm(1000, .5, .2))
  hist(x)
  plot(pegp3(x, kappa=2, sigma=1, xi=.5))

}
\references{
I. Papastathopoulos and J. A. Tawn, Extended generalized Pareto
modles for tail estimation, Journal of Statistical Planning and Inference,
143, 131 -- 143, 2013
}
\author{
Harry Southworth
}
\keyword{models}
