% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mock.R
\name{with_mock}
\alias{with_mock}
\alias{local_mock}
\title{Mock functions in a package.}
\usage{
with_mock(..., .env = topenv())

local_mock(..., .env = topenv(), .local_envir = parent.frame())
}
\arguments{
\item{...}{named parameters redefine mocked functions, unnamed parameters
will be evaluated after mocking the functions}

\item{.env}{the environment in which to patch the functions,
defaults to the top-level environment.  A character is interpreted as
package name.}

\item{.local_envir}{Environment in which to add exit handler.
For expert use only.}
}
\value{
The result of the last unnamed parameter
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}

\code{with_mock()} and \code{local_mock()} are superseded in favour of
\code{\link[=with_mocked_bindings]{with_mocked_bindings()}} and \code{\link[=local_mocked_bindings]{local_mocked_bindings()}}.

These works by using some C code to temporarily modify the mocked function
\emph{in place}. This is abusive of R's internals, which makes it dangerous, and
no longer recommended.
}
\section{3rd edition}{

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{with_mock()} and \code{local_mock()} are deprecated in the third edition.
}

\keyword{internal}
