% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect-comparison.R
\name{comparison-expectations}
\alias{comparison-expectations}
\alias{expect_lt}
\alias{expect_lte}
\alias{expect_gt}
\alias{expect_gte}
\title{Does code return a number greater/less than the expected value?}
\usage{
expect_lt(object, expected, label = NULL, expected.label = NULL)

expect_lte(object, expected, label = NULL, expected.label = NULL)

expect_gt(object, expected, label = NULL, expected.label = NULL)

expect_gte(object, expected, label = NULL, expected.label = NULL)
}
\arguments{
\item{object}{Computation and value to compare it to.

Both arguments supports limited unquoting to make it easier to generate
readable failures within a function or for loop. See \link{quasi_label} for
more details.}

\item{expected}{Single numeric value to compare.}

\item{label}{Used to customise failure messages. For expert
use only.}

\item{expected.label}{Used to customise failure messages. For expert
use only.}
}
\description{
Does code return a number greater/less than the expected value?
}
\examples{
a <- 9
expect_lt(a, 10)

\dontrun{
expect_lt(11, 10)
}

a <- 11
expect_gt(a, 10)
\dontrun{
expect_gt(9, 10)
}
}
\seealso{
Other expectations: 
\code{\link{equality-expectations}},
\code{\link{expect_error}()},
\code{\link{expect_length}()},
\code{\link{expect_match}()},
\code{\link{expect_named}()},
\code{\link{expect_null}()},
\code{\link{expect_output}()},
\code{\link{expect_reference}()},
\code{\link{expect_silent}()},
\code{\link{inheritance-expectations}},
\code{\link{logical-expectations}}
}
\concept{expectations}
