% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/expectations-equality.R
\name{equivalence}
\alias{equivalence}
\alias{expect_equal}
\alias{expect_equivalent}
\alias{expect_identical}
\title{Expectation: is the object equal to a value?}
\usage{
expect_equal(object, expected, ..., info = NULL, label = NULL,
  expected.label = NULL)

expect_equivalent(object, expected, info = NULL, label = NULL,
  expected.label = NULL)

expect_identical(object, expected, info = NULL, label = NULL,
  expected.label = NULL)
}
\arguments{
\item{object}{object to test}

\item{expected}{Expected value}

\item{...}{other values passed to \code{\link{all.equal}}}

\item{info}{extra information to be included in the message (useful when
writing tests in loops).}

\item{label}{For full form, label of expected object used in error
messages. Useful to override default (deparsed expected expression) when
doing tests in a loop.  For short cut form, object label. When
\code{NULL}, computed from deparsed object.}

\item{expected.label}{Equivalent of \code{label} for shortcut form.}
}
\description{
\itemize{
\item \code{expect_identical} tests with \code{\link{identical}}
\item \code{expect_equal} tests with \code{\link{all.equal}}
\item \code{expect_equivalent} tests with \code{\link{all.equal}} and
  \code{check.attributes = FALSE}
}
}
\examples{
a <- 10
expect_equal(a, 10)

# Use equals() when testing for numeric equality
sqrt(2) ^ 2 - 1
expect_equal(sqrt(2) ^ 2, 2)
# Neither of these forms take floating point representation errors into
# account
\dontrun{
expect_true(sqrt(2) ^ 2 == 2)
expect_identical(sqrt(2) ^ 2, 2)
}

# You can pass on additional arguments to all.equal:
\dontrun{
# Test the ABSOLUTE difference is within .002
expect_equal(object = 10.01, expected = 10, tolerance = .002,
  scale = 1)

# Test the RELATIVE difference is within .002
expectedValue <- 10
expect_equal(object = 10.01, expected = expectedValue, tolerance = 0.002,
  scale = expectedValue)
}

# expect_equalivalent ignores attributes
a <- b <- 1:3
names(b) <- letters[1:3]
expect_equivalent(a, b)
}
\seealso{
Other expectations: \code{\link{expect-compare}},
  \code{\link{expect_less_than}},
  \code{\link{expect_more_than}};
  \code{\link{expect_equal_to_reference}};
  \code{\link{expect_error}}, \code{\link{expect_match}},
  \code{\link{expect_message}},
  \code{\link{expect_output}},
  \code{\link{expect_warning}},
  \code{\link{matching-expectations}};
  \code{\link{expect_false}}, \code{\link{expect_true}};
  \code{\link{expect_is}}; \code{\link{expect_named}};
  \code{\link{expect_null}}; \code{\link{takes_less_than}}
}

