% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMemoryUsage.R
\name{plotMemoryUsage}
\alias{plotMemoryUsage}
\title{Asymptotic Memory Usage Plot function}
\usage{
plotMemoryUsage(
  data.df,
  titles = list("", ""),
  labels = list("Data sizes", "Memory usage (in bytes)"),
  point.alpha = 1,
  line.alpha = 1,
  point.color = "black",
  line.color = "black",
  point.size = 1.3,
  line.size = 0.7
)
}
\arguments{
\item{data.df}{A data frame composed of columns 'Memory Usage' and 'Data sizes', which can be obtained by asymptoticMemoryUsage()}

\item{titles}{A list of two elements consisting of strings for the plot title and subtitle.
Optional, with default values set to empty strings. (no titles/subtitles)}

\item{labels}{A list of two elements containing strings for x and y labels respectively.
Optional, with default values set to appropriate labels.}

\item{point.alpha}{A numeric value denoting transparency level (in the range 0 to 1) for point geometry.
Optional, with the default value set to 1. (no transparentness)}

\item{line.alpha}{A numeric value denoting transparency level (in the range 0 to 1) for line geometry.
Optional, with the default value set to 1. (no transparentness)}

\item{point.color}{A string specifying a known color or a representation in hexcode for point geometry.
Optional, with the default color set as black. (Hex equivalent: #000000)}

\item{line.color}{A string specifying a known color or a representation in hexcode for line geometry.
Optional, with the default color set as black. (Hex equivalent: #000000)}

\item{point.size}{A numeric value denoting the size of point geometry.
Optional, with the default value set to (1.3).}

\item{line.size}{A numeric value denoting the size of line geometry.
Optional, with the default value set to (0.7).}
}
\value{
A ggplot object.
}
\description{
Function to plot timings vs data sizes from the data frame returned by asymptoticMemoryUsage()
}
\details{
For more information regarding its implementation or functionality/usage, please check https://anirban166.github.io//Plotters/
}
\examples{
# Quantifying the memory usage for the allocation of a square matrix (N*N dimensions)
# against a set of input data sizes:
input.sizes = 10^seq(1, 3, by = 0.1)
memory.usage.data <- asymptoticMemoryUsage(matrix(data = N:N, nrow = N, ncol = N), input.sizes)
# Plotting the trend between computed memory allocations and data sizes:
plotMemoryUsage(memory.usage.data)
}
