% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/incidence_rate.R
\name{incidence_rate}
\alias{incidence_rate}
\alias{estimate_incidence_rate}
\alias{s_incidence_rate}
\alias{a_incidence_rate}
\title{Incidence rate estimation}
\usage{
estimate_incidence_rate(
  lyt,
  vars,
  n_events,
  id_var = "USUBJID",
  control = control_incidence_rate(),
  na_str = default_na_str(),
  nested = TRUE,
  summarize = FALSE,
  label_fmt = "\%s - \%.labels",
  ...,
  show_labels = "hidden",
  table_names = vars,
  .stats = c("person_years", "n_events", "rate", "rate_ci"),
  .formats = NULL,
  .labels = NULL,
  .indent_mods = NULL
)

s_incidence_rate(
  df,
  .var,
  n_events,
  is_event = lifecycle::deprecated(),
  id_var = "USUBJID",
  control = control_incidence_rate()
)

a_incidence_rate(
  df,
  labelstr = "",
  .var,
  .df_row,
  n_events,
  id_var = "USUBJID",
  control = control_incidence_rate(),
  .stats = NULL,
  .formats = c(person_years = "xx.x", n_events = "xx", rate = "xx.xx", rate_ci =
    "(xx.xx, xx.xx)", n_unique = "xx", n_rate = "xx (xx.x)"),
  .labels = NULL,
  .indent_mods = NULL,
  na_str = default_na_str(),
  label_fmt = "\%s - \%.labels"
)
}
\arguments{
\item{lyt}{(\code{PreDataTableLayouts})\cr layout that analyses will be added to.}

\item{vars}{(\code{character})\cr variable names for the primary analysis variable to be iterated over.}

\item{n_events}{(\code{string})\cr name of integer variable indicating whether an event has been observed (1) or not (0).}

\item{id_var}{(\code{string})\cr name of variable used as patient identifier if \code{"n_unique"} is included in \code{.stats}.
Defaults to \code{"USUBJID"}.}

\item{control}{(\code{list})\cr parameters for estimation details, specified by using
the helper function \code{\link[=control_incidence_rate]{control_incidence_rate()}}. Possible parameter options are:
\itemize{
\item \code{conf_level} (\code{proportion})\cr confidence level for the estimated incidence rate.
\item \code{conf_type} (\code{string})\cr \code{normal} (default), \code{normal_log}, \code{exact}, or \code{byar}
for confidence interval type.
\item \code{input_time_unit} (\code{string})\cr \code{day}, \code{week}, \code{month}, or \code{year} (default)
indicating time unit for data input.
\item \code{num_pt_year} (\code{numeric})\cr time unit for desired output (in person-years).
}}

\item{na_str}{(\code{string})\cr string used to replace all \code{NA} or empty values in the output.}

\item{nested}{(\code{flag})\cr whether this layout instruction should be applied within the existing layout structure _if
possible (\code{TRUE}, the default) or as a new top-level element (\code{FALSE}). Ignored if it would nest a split.
underneath analyses, which is not allowed.}

\item{summarize}{(\code{flag})\cr whether the function should act as an analyze function (\code{summarize = FALSE}), or a
summarize function (\code{summarize = TRUE}). Defaults to \code{FALSE}.}

\item{label_fmt}{(\code{string})\cr how labels should be formatted after a row split occurs if \code{summarize = TRUE}. The
string should use \code{"\%s"} to represent row split levels, and \code{"\%.labels"} to represent labels supplied to the
\code{.labels} argument. Defaults to \code{"\%s - \%.labels"}.}

\item{...}{additional arguments for the lower level functions.}

\item{show_labels}{(\code{string})\cr label visibility: one of "default", "visible" and "hidden".}

\item{table_names}{(\code{character})\cr this can be customized in the case that the same \code{vars} are analyzed multiple
times, to avoid warnings from \code{rtables}.}

\item{.stats}{(\code{character})\cr statistics to select for the table. Run \code{get_stats("estimate_incidence_rate")}
to see available statistics for this function.}

\item{.formats}{(named \code{character} or \code{list})\cr formats for the statistics. See Details in \code{analyze_vars} for more
information on the \code{"auto"} setting.}

\item{.labels}{(named \code{character})\cr labels for the statistics (without indent).}

\item{.indent_mods}{(named \code{integer})\cr indent modifiers for the labels. Defaults to 0, which corresponds to the
unmodified default behavior. Can be negative.}

\item{df}{(\code{data.frame})\cr data set containing all analysis variables.}

\item{.var}{(\code{string})\cr single variable name that is passed by \code{rtables} when requested
by a statistics function.}

\item{is_event}{(\code{flag})\cr \code{TRUE} if event, \code{FALSE} if time to event is censored.}

\item{labelstr}{(\code{string})\cr label of the level of the parent split currently being summarized
(must be present as second argument in Content Row Functions). See \code{\link[rtables:summarize_row_groups]{rtables::summarize_row_groups()}}
for more information.}

\item{.df_row}{(\code{data.frame})\cr data frame across all of the columns for the given row split.}
}
\value{
\itemize{
\item \code{estimate_incidence_rate()} returns a layout object suitable for passing to further layouting functions,
or to \code{\link[rtables:build_table]{rtables::build_table()}}. Adding this function to an \code{rtable} layout will add formatted rows containing
the statistics from \code{s_incidence_rate()} to the table layout.
}

\itemize{
\item \code{s_incidence_rate()} returns the following statistics:
\itemize{
\item \code{person_years}: Total person-years at risk.
\item \code{n_events}: Total number of events observed.
\item \code{rate}: Estimated incidence rate.
\item \code{rate_ci}: Confidence interval for the incidence rate.
\item \code{n_unique}: Total number of patients with at least one event observed.
\item \code{n_rate}: Total number of events observed & estimated incidence rate.
}
}

\itemize{
\item \code{a_incidence_rate()} returns the corresponding list with formatted \code{\link[rtables:CellValue]{rtables::CellValue()}}.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

The analyze function \code{\link[=estimate_incidence_rate]{estimate_incidence_rate()}} creates a layout element to estimate an event rate adjusted for
person-years at risk, otherwise known as incidence rate. The primary analysis variable specified via \code{vars} is
the person-years at risk. In addition to this variable, the \code{n_events} variable for number of events observed (where
a value of 1 means an event was observed and 0 means that no event was observed) must also be specified.
}
\section{Functions}{
\itemize{
\item \code{estimate_incidence_rate()}: Layout-creating function which can take statistics function arguments
and additional format arguments. This function is a wrapper for \code{\link[rtables:analyze]{rtables::analyze()}}.

\item \code{s_incidence_rate()}: Statistics function which estimates the incidence rate and the
associated confidence interval.

\item \code{a_incidence_rate()}: Formatted analysis function which is used as \code{afun} in \code{estimate_incidence_rate()}.

}}
\examples{
df <- data.frame(
  USUBJID = as.character(seq(6)),
  CNSR = c(0, 1, 1, 0, 0, 0),
  AVAL = c(10.1, 20.4, 15.3, 20.8, 18.7, 23.4),
  ARM = factor(c("A", "A", "A", "B", "B", "B")),
  STRATA1 = factor(c("X", "Y", "Y", "X", "X", "Y"))
)
df$n_events <- 1 - df$CNSR

basic_table(show_colcounts = TRUE) \%>\%
  split_cols_by("ARM") \%>\%
  estimate_incidence_rate(
    vars = "AVAL",
    n_events = "n_events",
    control = control_incidence_rate(
      input_time_unit = "month",
      num_pt_year = 100
    )
  ) \%>\%
  build_table(df)

# summarize = TRUE
basic_table(show_colcounts = TRUE) \%>\%
  split_cols_by("ARM") \%>\%
  split_rows_by("STRATA1", child_labels = "visible") \%>\%
  estimate_incidence_rate(
    vars = "AVAL",
    n_events = "n_events",
    .stats = c("n_unique", "n_rate"),
    summarize = TRUE,
    label_fmt = "\%.labels"
  ) \%>\%
  build_table(df)

a_incidence_rate(
  df,
  .var = "AVAL",
  .df_row = df,
  n_events = "n_events"
)

}
\seealso{
\code{\link[=control_incidence_rate]{control_incidence_rate()}} and helper functions \link{h_incidence_rate}.
}
\keyword{internal}
