% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_variables.R
\name{summarize_variables}
\alias{summarize_variables}
\alias{s_summary}
\alias{s_summary.numeric}
\alias{s_summary.factor}
\alias{s_summary.character}
\alias{s_summary.logical}
\alias{a_summary}
\alias{a_summary.numeric}
\alias{a_summary.factor}
\alias{a_summary.character}
\alias{a_summary.logical}
\alias{summarize_vars}
\title{Summarize Variables}
\usage{
s_summary(x, na.rm = TRUE, denom, .N_row, .N_col, .var, ...)

\method{s_summary}{numeric}(
  x,
  na.rm = TRUE,
  denom,
  .N_row,
  .N_col,
  .var,
  control = control_summarize_vars(),
  ...
)

\method{s_summary}{factor}(
  x,
  na.rm = TRUE,
  denom = c("n", "N_row", "N_col"),
  .N_row,
  .N_col,
  ...
)

\method{s_summary}{character}(
  x,
  na.rm = TRUE,
  denom = c("n", "N_row", "N_col"),
  .N_row,
  .N_col,
  .var,
  verbose = TRUE,
  ...
)

\method{s_summary}{logical}(
  x,
  na.rm = TRUE,
  denom = c("n", "N_row", "N_col"),
  .N_row,
  .N_col,
  ...
)

a_summary(x, ..., .N_row, .N_col, .var)

\method{a_summary}{numeric}(
  x,
  na.rm = TRUE,
  denom,
  .N_row,
  .N_col,
  .var,
  control = control_summarize_vars(),
  ...
)

\method{a_summary}{factor}(
  x,
  na.rm = TRUE,
  denom = c("n", "N_row", "N_col"),
  .N_row,
  .N_col,
  ...
)

\method{a_summary}{character}(
  x,
  na.rm = TRUE,
  denom = c("n", "N_row", "N_col"),
  .N_row,
  .N_col,
  .var,
  verbose = TRUE,
  ...
)

\method{a_summary}{logical}(
  x,
  na.rm = TRUE,
  denom = c("n", "N_row", "N_col"),
  .N_row,
  .N_col,
  ...
)

summarize_vars(
  lyt,
  vars,
  var_labels = vars,
  nested = TRUE,
  ...,
  na_level = NA_character_,
  show_labels = "default",
  table_names = vars,
  section_div = NA_character_,
  .stats = c("n", "mean_sd", "median", "range", "count_fraction"),
  .formats = NULL,
  .labels = NULL,
  .indent_mods = NULL
)
}
\arguments{
\item{x}{(\code{numeric})\cr vector of numbers we want to analyze.}

\item{na.rm}{(\code{flag})\cr whether \code{NA} values should be removed from \code{x} prior to analysis.}

\item{denom}{(\code{string})\cr choice of denominator for proportion. Options are:
\itemize{
\item \code{n}: number of values in this row and column intersection.
\item \code{N_row}: total number of values in this row across columns.
\item \code{N_col}: total number of values in this column across rows.
}}

\item{.N_row}{(\code{count})\cr column-wise N (column count) for the full column that is passed by \code{rtables}.}

\item{.N_col}{(\code{count})\cr row-wise N (row group count) for the group of observations being analyzed
(i.e. with no column-based subsetting) that is passed by \code{rtables}.}

\item{.var}{(\code{string})\cr single variable name that is passed by \code{rtables} when requested
by a statistics function.}

\item{...}{arguments passed to \code{s_summary()}.}

\item{control}{(\code{list})\cr parameters for descriptive statistics details, specified by using
the helper function \code{\link[=control_summarize_vars]{control_summarize_vars()}}. Some possible parameter options are:
\itemize{
\item \code{conf_level} (\code{proportion})\cr confidence level of the interval for mean and median.
\item \code{quantiles} (\code{numeric})\cr vector of length two to specify the quantiles.
\item \code{quantile_type} (\code{numeric})\cr between 1 and 9 selecting quantile algorithms to be used.
See more about \code{type} in \code{\link[stats:quantile]{stats::quantile()}}.
\item \code{test_mean} (\code{numeric})\cr value to test against the mean under the null hypothesis when calculating p-value.
}}

\item{verbose}{(\code{logical})\cr Defaults to \code{TRUE}, which prints out warnings and messages. It is mainly used
to print out information about factor casting.}

\item{lyt}{(\code{layout})\cr input layout where analyses will be added to.}

\item{vars}{(\code{character})\cr variable names for the primary analysis variable to be iterated over.}

\item{var_labels}{(\code{character})\cr character for label.}

\item{nested}{(\code{flag})\cr whether this layout instruction be applied within the existing layout structure \emph{if
possible} (\code{TRUE}, the default) or as a new top-level element (\code{FALSE}). Ignored if it would nest a split
underneath analyses, which is not allowed.}

\item{na_level}{(\code{string})\cr string used to replace all \code{NA} or empty values in the output.}

\item{show_labels}{(\code{string})\cr label visibility: one of "default", "visible" and "hidden".}

\item{table_names}{(\code{character})\cr this can be customized in case that the same \code{vars} are analyzed multiple times,
to avoid warnings from \code{rtables}.}

\item{section_div}{(\code{string})\cr string which should be repeated as a section divider after each group
defined by this split instruction, or \code{NA_character_} (the default) for no section divider.}

\item{.stats}{(\code{character})\cr statistics to select for the table.}

\item{.formats}{(named \code{character} or \code{list})\cr formats for the statistics.}

\item{.labels}{(named \code{character})\cr labels for the statistics (without indent).}

\item{.indent_mods}{(named \code{vector} of \code{integer})\cr indent modifiers for the labels. Each element of the vector
should be a name-value pair with name corresponding to a statistic specified in \code{.stats} and value the indentation
for that statistic's row label.}
}
\value{
\itemize{
\item \code{s_summary()} returns different statistics depending on the class of \code{x}.
}

\itemize{
\item If \code{x} is of class \code{numeric}, returns a \code{list} with the following named \code{numeric} items:
\itemize{
\item \code{n}: The \code{\link[=length]{length()}} of \code{x}.
\item \code{sum}: The \code{\link[=sum]{sum()}} of \code{x}.
\item \code{mean}: The \code{\link[=mean]{mean()}} of \code{x}.
\item \code{sd}: The \code{\link[stats:sd]{stats::sd()}} of \code{x}.
\item \code{se}: The standard error of \code{x} mean, i.e.: (\code{sd(x) / sqrt(length(x))}).
\item \code{mean_sd}: The \code{\link[=mean]{mean()}} and \code{\link[stats:sd]{stats::sd()}} of \code{x}.
\item \code{mean_se}: The \code{\link[=mean]{mean()}} of \code{x} and its standard error (see above).
\item \code{mean_ci}: The CI for the mean of \code{x} (from \code{\link[=stat_mean_ci]{stat_mean_ci()}}).
\item \code{mean_sei}: The SE interval for the mean of \code{x}, i.e.: (\code{\link[=mean]{mean()}} -/+ \code{\link[stats:sd]{stats::sd()}} / \code{\link[=sqrt]{sqrt()}}).
\item \code{mean_sdi}: The SD interval for the mean of \code{x}, i.e.: (\code{\link[=mean]{mean()}} -/+ \code{\link[stats:sd]{stats::sd()}}).
\item \code{mean_pval}: The two-sided p-value of the mean of \code{x} (from \code{\link[=stat_mean_pval]{stat_mean_pval()}}).
\item \code{median}: The \code{\link[stats:median]{stats::median()}} of \code{x}.
\item \code{mad}: The median absolute deviation of \code{x}, i.e.: (\code{\link[stats:median]{stats::median()}} of \code{xc},
where \code{xc} = \code{x} - \code{\link[stats:median]{stats::median()}}).
\item \code{median_ci}: The CI for the median of \code{x} (from \code{\link[=stat_median_ci]{stat_median_ci()}}).
\item \code{quantiles}: Two sample quantiles of \code{x} (from \code{\link[stats:quantile]{stats::quantile()}}).
\item \code{iqr}: The \code{\link[stats:IQR]{stats::IQR()}} of \code{x}.
\item \code{range}: The \code{\link[=range_noinf]{range_noinf()}} of \code{x}.
\item \code{min}: The \code{\link[=max]{max()}} of \code{x}.
\item \code{max}: The \code{\link[=min]{min()}} of \code{x}.
\item \code{median_range}: The \code{\link[=median]{median()}} and \code{\link[=range_noinf]{range_noinf()}} of \code{x}.
\item \code{cv}: The coefficient of variation of \code{x}, i.e.: (\code{\link[stats:sd]{stats::sd()}} / \code{\link[=mean]{mean()}} * 100).
\item \code{geom_mean}: The geometric mean of \code{x}, i.e.: (\code{exp(mean(log(x)))}).
\item \code{geom_cv}: The geometric coefficient of variation of \code{x}, i.e.: (\code{sqrt(exp(sd(log(x)) ^ 2) - 1) * 100}).
}
}

\itemize{
\item If \code{x} is of class \code{factor} or converted from \code{character}, returns a \code{list} with named \code{numeric} items:
\itemize{
\item \code{n}: The \code{\link[=length]{length()}} of \code{x}.
\item \code{count}: A list with the number of cases for each level of the factor \code{x}.
\item \code{count_fraction}: Similar to \code{count} but also includes the proportion of cases for each level of the
factor \code{x} relative to the denominator, or \code{NA} if the denominator is zero.
}
}

\itemize{
\item If \code{x} is of class \code{logical}, returns a \code{list} with named \code{numeric} items:
\itemize{
\item \code{n}: The \code{\link[=length]{length()}} of \code{x} (possibly after removing \code{NA}s).
\item \code{count}: Count of \code{TRUE} in \code{x}.
\item \code{count_fraction}: Count and proportion of \code{TRUE} in \code{x} relative to the denominator, or \code{NA} if the
denominator is zero. Note that \code{NA}s in \code{x} are never counted or leading to \code{NA} here.
}
}

\itemize{
\item \code{a_summary()} returns the corresponding list with formatted \code{\link[rtables:CellValue]{rtables::CellValue()}}.
}

\itemize{
\item \code{summarize_vars()} returns a layout object suitable for passing to further layouting functions,
or to \code{\link[rtables:build_table]{rtables::build_table()}}. Adding this function to an \code{rtable} layout will add formatted rows containing
the statistics from \code{s_summary()} to the table layout.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

We use the S3 generic function \code{\link[=s_summary]{s_summary()}} to implement summaries for different \code{x} objects. This
is used as a statistics function in combination with the analyze function \code{\link[=summarize_vars]{summarize_vars()}}.
}
\section{Functions}{
\itemize{
\item \code{s_summary()}: S3 generic function to produces a variable summary.

\item \code{s_summary(numeric)}: Method for \code{numeric} class.

\item \code{s_summary(factor)}: Method for \code{factor} class.

\item \code{s_summary(character)}: Method for \code{character} class. This makes an automatic
conversion to factor (with a warning) and then forwards to the method for factors.

\item \code{s_summary(logical)}: Method for \code{logical} class.

\item \code{a_summary()}: Formatted analysis function which is used as \code{afun} in \code{summarize_vars()}.

\item \code{a_summary(numeric)}: Formatted analysis function method for \code{numeric} class.

\item \code{a_summary(factor)}: Formatted analysis function method for \code{factor} class.

\item \code{a_summary(character)}: Formatted analysis function method for \code{character} class.

\item \code{a_summary(logical)}: Formatted analysis function method for \code{logical} class.

\item \code{summarize_vars()}: Layout-creating function which can take statistics function arguments
and additional format arguments. This function is a wrapper for \code{\link[rtables:analyze]{rtables::analyze()}}.

}}
\note{
\itemize{
\item If \code{x} is an empty vector, \code{NA} is returned. This is the expected feature so as to return \code{rcell} content in
\code{rtables} when the intersection of a column and a row delimits an empty data selection.
\item When the \code{mean} function is applied to an empty vector, \code{NA} will be returned instead of \code{NaN}, the latter
being standard behavior in R.
}

\itemize{
\item If \code{x} is an empty \code{factor}, a list is still returned for \code{counts} with one element
per factor level. If there are no levels in \code{x}, the function fails.
\item If factor variables contain \code{NA}, these \code{NA} values are excluded by default. To include \code{NA} values
set \code{na.rm = FALSE} and missing values will be displayed as an \code{NA} level. Alternatively, an explicit
factor level can be defined for \code{NA} values during pre-processing via \code{\link[=df_explicit_na]{df_explicit_na()}} - the
default \code{na_level} (\code{"<Missing>"}) will also be excluded when \code{na.rm} is set to \code{TRUE}.
}

\itemize{
\item Automatic conversion of character to factor does not guarantee that the table
can be generated correctly. In particular for sparse tables this very likely can fail.
It is therefore better to always pre-process the dataset such that factors are manually
created from character variables before passing the dataset to \code{\link[rtables:build_table]{rtables::build_table()}}.
}
}
\examples{
# `s_summary.numeric`

## Basic usage: empty numeric returns NA-filled items.
s_summary(numeric())

## Management of NA values.
x <- c(NA_real_, 1)
s_summary(x, na.rm = TRUE)
s_summary(x, na.rm = FALSE)

x <- c(NA_real_, 1, 2)
s_summary(x, stats = NULL)

## Benefits in `rtables` contructions:
require(rtables)
dta_test <- data.frame(
  Group = rep(LETTERS[1:3], each = 2),
  sub_group = rep(letters[1:2], each = 3),
  x = 1:6
)

## The summary obtained in with `rtables`:
basic_table() \%>\%
  split_cols_by(var = "Group") \%>\%
  split_rows_by(var = "sub_group") \%>\%
  analyze(vars = "x", afun = s_summary) \%>\%
  build_table(df = dta_test)

## By comparison with `lapply`:
X <- split(dta_test, f = with(dta_test, interaction(Group, sub_group)))
lapply(X, function(x) s_summary(x$x))

# `s_summary.factor`

## Basic usage:
s_summary(factor(c("a", "a", "b", "c", "a")))
# Empty factor returns NA-filled items.
s_summary(factor(levels = c("a", "b", "c")))

## Management of NA values.
x <- factor(c(NA, "Female"))
x <- explicit_na(x)
s_summary(x, na.rm = TRUE)
s_summary(x, na.rm = FALSE)

## Different denominators.
x <- factor(c("a", "a", "b", "c", "a"))
s_summary(x, denom = "N_row", .N_row = 10L)
s_summary(x, denom = "N_col", .N_col = 20L)

# `s_summary.character`

## Basic usage:
s_summary(c("a", "a", "b", "c", "a"), .var = "x", verbose = FALSE)
s_summary(c("a", "a", "b", "c", "a", ""), .var = "x", na.rm = FALSE, verbose = FALSE)

# `s_summary.logical`

## Basic usage:
s_summary(c(TRUE, FALSE, TRUE, TRUE))

## Management of NA values.
x <- c(NA, TRUE, FALSE)
s_summary(x, na.rm = TRUE)
s_summary(x, na.rm = FALSE)

## Different denominators.
x <- c(TRUE, FALSE, TRUE, TRUE)
s_summary(x, denom = "N_row", .N_row = 10L)
s_summary(x, denom = "N_col", .N_col = 20L)

# `a_summary.numeric`
a_summary(rnorm(10), .N_col = 10, .N_row = 20, .var = "bla")

# `a_summary.factor`
# We need to ungroup `count` and `count_fraction` first so that the rtables formatting
# functions can be applied correctly.
afun <- make_afun(
  getS3method("a_summary", "factor"),
  .ungroup_stats = c("count", "count_fraction")
)
afun(factor(c("a", "a", "b", "c", "a")), .N_row = 10, .N_col = 10)

# `a_summary.character`
afun <- make_afun(
  getS3method("a_summary", "character"),
  .ungroup_stats = c("count", "count_fraction")
)
afun(c("A", "B", "A", "C"), .var = "x", .N_col = 10, .N_row = 10, verbose = FALSE)

# `a_summary.logical`
afun <- make_afun(
  getS3method("a_summary", "logical")
)
afun(c(TRUE, FALSE, FALSE, TRUE, TRUE), .N_row = 10, .N_col = 10)

## Fabricated dataset.
dta_test <- data.frame(
  USUBJID = rep(1:6, each = 3),
  PARAMCD = rep("lab", 6 * 3),
  AVISIT  = rep(paste0("V", 1:3), 6),
  ARM     = rep(LETTERS[1:3], rep(6, 3)),
  AVAL    = c(9:1, rep(NA, 9))
)

# `summarize_vars()` in `rtables` pipelines
## Default output within a `rtables` pipeline.
l <- basic_table() \%>\%
  split_cols_by(var = "ARM") \%>\%
  split_rows_by(var = "AVISIT") \%>\%
  summarize_vars(vars = "AVAL")

build_table(l, df = dta_test)

## Select and format statistics output.
l <- basic_table() \%>\%
  split_cols_by(var = "ARM") \%>\%
  split_rows_by(var = "AVISIT") \%>\%
  summarize_vars(
    vars = "AVAL",
    .stats = c("n", "mean_sd", "quantiles"),
    .formats = c("mean_sd" = "xx.x, xx.x"),
    .labels = c(n = "n", mean_sd = "Mean, SD", quantiles = c("Q1 - Q3"))
  )

results <- build_table(l, df = dta_test)
as_html(results)

## Use arguments interpreted by `s_summary`.
l <- basic_table() \%>\%
  split_cols_by(var = "ARM") \%>\%
  split_rows_by(var = "AVISIT") \%>\%
  summarize_vars(vars = "AVAL", na.rm = FALSE)

results <- build_table(l, df = dta_test)

## Handle `NA` levels first when summarizing factors.
dta_test$AVISIT <- NA_character_
dta_test <- df_explicit_na(dta_test)
l <- basic_table() \%>\%
  split_cols_by(var = "ARM") \%>\%
  summarize_vars(vars = "AVISIT", na.rm = FALSE)

results <- build_table(l, df = dta_test)
\donttest{
Viewer(results)
}

}
