% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control.simulate.tergm.R
\name{control.simulate.tergm}
\alias{control.simulate.tergm}
\alias{control.simulate.formula.tergm}
\title{Auxiliary for Controlling Temporal ERGM Simulation}
\usage{
control.simulate.tergm(
  MCMC.burnin.min = NULL,
  MCMC.burnin.max = NULL,
  MCMC.burnin.pval = NULL,
  MCMC.burnin.add = NULL,
  MCMC.prop = NULL,
  MCMC.prop.weights = NULL,
  MCMC.prop.args = NULL,
  MCMC.maxedges = NULL,
  MCMC.maxchanges = NULL,
  term.options = NULL,
  MCMC.packagenames = NULL
)

control.simulate.formula.tergm(
  MCMC.burnin.min = 1000,
  MCMC.burnin.max = 1e+05,
  MCMC.burnin.pval = 0.5,
  MCMC.burnin.add = 1,
  MCMC.prop = ~discord + sparse,
  MCMC.prop.weights = "default",
  MCMC.prop.args = NULL,
  MCMC.maxedges = Inf,
  MCMC.maxchanges = 1e+06,
  term.options = NULL,
  MCMC.packagenames = c()
)
}
\arguments{
\item{MCMC.burnin.min, MCMC.burnin.max, MCMC.burnin.pval, MCMC.burnin.add}{Number of Metropolis-Hastings steps
per time step used in simulation. By default, this
is determined adaptively by keeping track of increments in the
Hamming distance between the transitioned-from network and the
network being sampled. Once \code{MCMC.burnin.min} steps have elapsed, the
increments are tested against 0, and when their average number
becomes statistically indistinguishable from 0 (with the p-value
being greater than \code{MCMC.burnin.pval}), or
\code{MCMC.burnin.max} steps are proposed, whichever comes first,
the simulation is stopped after an additional
\code{MCMC.burnin.add} times the number of elapsed steps have been
taken.  (Stopping immediately would bias the sampling.)

To use a fixed number of steps, set \code{MCMC.burnin.min}
and \code{MCMC.burnin.max} to the same value.}

\item{MCMC.prop}{Hints and/or constraints for selecting and initializing the proposal.}

\item{MCMC.prop.weights}{Specifies the proposal weighting scheme to
be used in the MCMC Metropolis-Hastings algorithm.  Possible
choices may be determined by calling \code{\link{ergm_proposal_table}}.}

\item{MCMC.prop.args}{An alternative, direct way of specifying
additional arguments to the proposal.}

\item{MCMC.maxedges}{The maximum number of edges that may occur during the MCMC sampling. If this number is exceeded at any time, sampling is stopped immediately.}

\item{MCMC.maxchanges}{Maximum number of changes for
which to allocate space.}

\item{term.options}{A list of additional arguments to be passed to term initializers. See \code{\link[=term.options]{? term.options}}.}

\item{MCMC.packagenames}{Names of packages in which to look for change
statistic functions in addition to those autodetected. This argument should
not be needed outside of very strange setups.}
}
\value{
A list with arguments as components.
}
\description{
Auxiliary function as user interface for fine-tuning TERGM simulation.
}
\details{
This function is only used within a call to the \code{\link{simulate}}
function.  See the \code{usage} section in \code{\link{simulate.tergm}} for
details.
}
\seealso{
\code{\link{simulate.tergm}},
\code{\link{simulate.formula}}.  \code{\link{control.tergm}}
performs a similar function for \code{\link{tergm}}.
}
\keyword{models}
