% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tensor_regress.R
\name{sim_data}
\alias{sim_data}
\title{Simulation of tensor regression models}
\usage{
sim_data(
  seed,
  whole_shape = c(20, 20, 20),
  core_shape = c(3, 3, 3),
  p = c(3, 3, 0),
  dist,
  dup,
  signal,
  block = rep(FALSE, 3)
)
}
\arguments{
\item{seed}{a random seed for generating data}

\item{whole_shape}{a vector containing dimension of the tensor}

\item{core_shape}{a vector containing Tucker rank of the coefficient tensor}

\item{p}{a vector containing numbers of covariates on each mode, see "details"}

\item{dist}{distribution of response tensor, see "details"}

\item{dup}{number of simulated tensors from the same linear predictor}

\item{signal}{a scalar controlling the max norm of the linear predictor}

\item{block}{a vector containing boolean variables, see "details"}
}
\value{
a list containing the following:

\code{tsr} {a list of simulated tensors, with the number of replicates specified by \code{dup}}

\code{X_covar1}  {a matrix, covariate on first mode}

\code{X_covar2}  {a matrix, covariate on second mode}

\code{X_covar3}  {a matrix, covariate on third mode}

\code{W} {a list of orthogonal coefficient matrices - one for each mode, with the number of columns given by \code{core_shape}}

\code{G}  {an array, core tensor with size specified by \code{core_shape}}

\code{C_ts}  {an array, coefficient tensor, Tucker product of \code{G},\code{A},\code{B},\code{C}}

\code{U} {an array, linear predictor,i.e. Tucker product of \code{C_ts},\code{X_covar1},\code{X_covar2},\code{X_covar3}}
}
\description{
Generate response tensors with multiple covariates under different simulation models, specifically for tensors with 3 modes
}
\details{
By default non-positive entry in \code{p} indicates no covariate on the corresponding mode of the tensor.

            \code{dist} specifies three distributions of response tensor: binary, poisson or normal distribution.

            \code{block} specifies whether the coefficient factor matrix is a membership matrix, set to \code{TRUE} when utilizing the stochastic block model
}
\examples{
seed = 34
dist = 'binary'
data=sim_data(seed, whole_shape = c(20,20,20), core_shape=c(3,3,3),
p=c(5,5,5),dist=dist, dup=5, signal=4)
}
