% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seed.R
\name{set_random_seed}
\alias{set_random_seed}
\title{Set random seed for TensorFlow}
\usage{
set_random_seed(seed, disable_gpu = TRUE)
}
\arguments{
\item{seed}{A single value, interpreted as an integer}

\item{disable_gpu}{\code{TRUE} to disable GPU execution (see \emph{Parallelism} below).}
}
\description{
Sets all random seeds needed to make TensorFlow code reproducible.
}
\details{
This function should be used instead of \code{\link[=use_session_with_seed]{use_session_with_seed()}} if
you are using TensorFlow >= 2.0, as the concept of \code{session} doesn't
really make sense anymore.

This functions sets:
\itemize{
\item The R random seed with \code{\link[=set.seed]{set.seed()}}.
\item The python and Numpy seeds via (\code{\link[reticulate:py_set_seed]{reticulate::py_set_seed()}}).
\item The TensorFlow seed with (\code{tf$random$set_seed()})
}

It also optionally disables the GPU execution as this is a potential
source of non-reproducibility.
}
