% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TEMPTED.R
\name{plot_feature_summary}
\alias{plot_feature_summary}
\title{Plot nonparametric smoothed mean and error bands of features versus time}
\usage{
plot_feature_summary(
  feature_mat,
  time_vec,
  group_vec,
  coverage = 0.95,
  bws = NULL,
  nrow = 1
)
}
\arguments{
\item{feature_mat}{A sample by feature matrix. Each feature will be plotted separately as a facet.
The features can be original features, meta features, log ratios, or any variables of interest.}

\item{time_vec}{A vector of time points matched to the rows of \code{feature_mat}.}

\item{group_vec}{A vector of factor variable indicating the group membership
of samples matched to the rows of \code{feature_mat}.}

\item{coverage}{The coverage rate for the error band. Default is 0.95.}

\item{bws}{The smoothness parameter for the smoothing lines and error bands.
A larger value means a smoother line.
Default is NULL and calculated by function \code{np::npreg()}.}

\item{nrow}{The number of rows to plot the features used in function \code{ggplot2::facet_wrap()}.}
}
\value{
A ggplot2 object.
}
\description{
This is a handy function to plot the smoothed mean and error bands for multiple features.
}
\examples{
# plot the summary of selected features

feat.names <- c("OTU4447072", "OTU4467447")

proportion_table <- count_table/rowSums(count_table)

plot_feature_summary(proportion_table[,feat.names],
                     meta_table$day_of_life,
                     meta_table$delivery,
                     bws=30)
}
