% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcata.R
\encoding{UTF-8}
\name{convert.tcata}
\alias{convert.tcata}
\title{Convert TCATA data}
\usage{
convert.tcata(X, times, decimal.places = 2)
}
\arguments{
\item{X}{matrix with onset (start) times in first column and offset (stop) times in second column}

\item{times}{time slices for output indicator vector}

\item{decimal.places}{decimal places used in \code{times}; used for naming of the indices of \code{out.vec}}
}
\value{
out.vec indictor vector(\code{0}s and \code{1}s)
}
\description{
Converts TCATA data from a set of onset-offset times to an indicator vector (\code{0}s and \code{1}s). Also works for TDS data.
}
\examples{
X <- rbind(c(3.18, 6.83), c(8.46, 11.09), c(18.61, 21.80))
times <- seq(0, 25, by = 0.01)
Xnew <- convert.tcata(X, times)
Xnew
}

