% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/messagehandler.R
\docType{class}
\name{MessageHandler}
\alias{MessageHandler}
\title{MessageHandler}
\format{An \code{\link{R6Class}} object.}
\usage{
MessageHandler(callback, filters = NULL)
}
\arguments{
\item{callback}{The callback function for this handler.
See \code{\link{Handler}} for information about this function.}

\item{filters}{(Optional). Only allow updates with these Filters. Use \code{NULL}
(default) or \code{Filters$all} for no filtering. See \code{\link{Filters}} for a
full list of all available filters.}
}
\description{
\code{\link{Handler}} class to handle Telegram messages. They might contain text, media or status updates.
}
\examples{
\dontrun{
callback_method <- function(bot, update){
  chat_id <- update$message$chat_id
  bot$sendMessage(chat_id = chat_id, text = 'Hello')
}

# No filtering
message_handler <- MessageHandler(callback_method, Filters$all)
}
}
