% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_models.R
\docType{data}
\name{pb2002}
\alias{pb2002}
\title{Global model of current plate motions}
\format{
An object of class \code{data.frame}
\describe{
\item{plate.name}{The rotating plate}
\item{plate.rot}{The abbreviation of the plate's name}
\item{lat,lon}{Coordinates of the Pole of Rotation}
\item{angle}{The amount of rotation (angle in 1 Myr)}
\item{plate.fix}{The anchored plate, i.e. \code{plate.rot} moves relative
to \code{plate.fix}}
\item{source}{Reference to underlying study}
}
}
\usage{
data('pb2002')
}
\description{
PB2002 global model of current plate motions by Bird 2003
}
\examples{
data("pb2002")
head("pb2002")
}
\references{
Bird, P. (2003), An updated digital model of plate boundaries,
\emph{Geochem. Geophys. Geosyst.}, \strong{4}, 1027, doi: 10.1029/2001GC000252, 3.
}
\keyword{datasets}
