% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_with_settings.R
\name{table_with_settings}
\alias{table_with_settings}
\alias{table_with_settings_ui}
\alias{table_with_settings_srv}
\title{table_with_settings module}
\usage{
table_with_settings_ui(id, ...)

table_with_settings_srv(id, table_r, show_hide_signal = reactive(TRUE))
}
\arguments{
\item{id}{An ID string that corresponds with the ID used to call the module's
UI function.}

\item{...}{(\code{character})\cr
Useful for providing additional HTML classes for the output tag.}

\item{table_r}{(\code{reactive})\cr
reactive expression that yields an \code{rtable} object (\code{ElementaryTable} or \code{TableTree})}

\item{show_hide_signal}{(\verb{reactive logical}, optional)\cr
a mechanism to allow modules which call this module to show/hide the table_with_settings UI.}
}
\value{
A \code{shiny} module.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\examples{
library(shiny)
library(rtables)
library(magrittr)
app <- shinyApp(
  ui = fluidPage(
    table_with_settings_ui(
      id = "table_with_settings"
    )
  ),
  server = function(input, output, session) {
    table_r <- reactive({
      l <- basic_table() \%>\%
        split_cols_by("ARM") \%>\%
        analyze(c("SEX", "AGE"))

      tbl <- build_table(l, DM)

      tbl
    })

    table_with_settings_srv(id = "table_with_settings", table_r = table_r)
  }
)
if (interactive()) {
  app
}

}
