% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot2_args.R
\name{resolve_ggplot2_args}
\alias{resolve_ggplot2_args}
\title{Resolving and reducing multiple \code{ggplot2_args} objects}
\usage{
resolve_ggplot2_args(
  user_plot = ggplot2_args(),
  user_default = ggplot2_args(),
  module_plot = ggplot2_args(),
  app_default = getOption("teal.ggplot2_args", ggplot2_args())
)
}
\arguments{
\item{user_plot}{(\code{ggplot2_args})\cr
end user setup for theme and labs in the specific plot.
Created with the \code{\link[=ggplot2_args]{ggplot2_args()}} function. The \code{NULL} value is supported.}

\item{user_default}{(\code{ggplot2_args})\cr
end user setup for module default theme and labs.
Created with the \code{\link[=ggplot2_args]{ggplot2_args()}} function. The \code{NULL} value is supported.}

\item{module_plot}{(\code{ggplot2_args})\cr
module creator setup for theme and labs in the specific plot.
Created with the \code{\link[=ggplot2_args]{ggplot2_args()}} function. The \code{NULL} value is supported.}

\item{app_default}{(\code{ggplot2_args})\cr
Application level setting. Can be \code{NULL}.}
}
\value{
\code{ggplot2_args} object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Resolving and reducing multiple \code{ggplot2_args} objects.
This function is intended to utilize user provided settings, defaults provided by the module creator and
also \code{teal} option. See \code{Details}, below, to understand the logic.
}
\details{
The function picks the first non \code{NULL} value for each argument, checking in the following order:
\enumerate{
\item \code{ggplot2_args} argument provided by the end user.
Per plot (\code{user_plot}) and then default (\code{user_default}) setup.
\item \code{app_default} global R variable, \code{teal.ggplot2_args}.
\item \code{module_plot} which is a module creator setup.
}
}
\examples{
resolve_ggplot2_args(
  user_plot = ggplot2_args(
    lab = list(title = "TITLE"),
    theme = list(title = ggplot2::element_text(size = 20))
  ),
  user_default = ggplot2_args(
    lab = list(x = "XLAB")
  )
)
}
\seealso{
\code{\link[=parse_ggplot2_args]{parse_ggplot2_args()}} to parse resolved list into list of calls.
}
