% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FilterStateEmpty.R
\docType{class}
\name{EmptyFilterState}
\alias{EmptyFilterState}
\title{\code{FilterState} object for empty variables}
\description{
\code{FilterState} subclass representing an empty variable.
}
\examples{
# use non-exported function from teal.slice
include_js_files <- getFromNamespace("include_js_files", "teal.slice")
EmptyFilterState <- getFromNamespace("EmptyFilterState", "teal.slice")

library(shiny)

filter_state <- EmptyFilterState$new(
  x = NA,
  slice = teal_slice(varname = "x", dataname = "data"),
  extract_type = character(0)
)
isolate(filter_state$get_call())
filter_state$set_state(teal_slice(dataname = "data", varname = "x", keep_na = TRUE))
isolate(filter_state$get_call())

}
\keyword{internal}
\section{Super class}{
\code{\link[teal.slice:FilterState]{teal.slice::FilterState}} -> \code{EmptyFilterState}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-EmptyFilterState-new}{\code{EmptyFilterState$new()}}
\item \href{#method-EmptyFilterState-get_call}{\code{EmptyFilterState$get_call()}}
\item \href{#method-EmptyFilterState-clone}{\code{EmptyFilterState$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="teal.slice" data-topic="FilterState" data-id="finalize"><a href='../../teal.slice/html/FilterState.html#method-FilterState-finalize'><code>teal.slice::FilterState$finalize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="teal.slice" data-topic="FilterState" data-id="format"><a href='../../teal.slice/html/FilterState.html#method-FilterState-format'><code>teal.slice::FilterState$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="teal.slice" data-topic="FilterState" data-id="get_state"><a href='../../teal.slice/html/FilterState.html#method-FilterState-get_state'><code>teal.slice::FilterState$get_state()</code></a></span></li>
<li><span class="pkg-link" data-pkg="teal.slice" data-topic="FilterState" data-id="print"><a href='../../teal.slice/html/FilterState.html#method-FilterState-print'><code>teal.slice::FilterState$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="teal.slice" data-topic="FilterState" data-id="server"><a href='../../teal.slice/html/FilterState.html#method-FilterState-server'><code>teal.slice::FilterState$server()</code></a></span></li>
<li><span class="pkg-link" data-pkg="teal.slice" data-topic="FilterState" data-id="set_state"><a href='../../teal.slice/html/FilterState.html#method-FilterState-set_state'><code>teal.slice::FilterState$set_state()</code></a></span></li>
<li><span class="pkg-link" data-pkg="teal.slice" data-topic="FilterState" data-id="ui"><a href='../../teal.slice/html/FilterState.html#method-FilterState-ui'><code>teal.slice::FilterState$ui()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EmptyFilterState-new"></a>}}
\if{latex}{\out{\hypertarget{method-EmptyFilterState-new}{}}}
\subsection{Method \code{new()}}{
Initialize \code{EmptyFilterState} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EmptyFilterState$new(
  x,
  x_reactive = reactive(NULL),
  extract_type = character(0),
  slice
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{(\code{vector})
variable to be filtered,}

\item{\code{x_reactive}}{(\code{reactive})
returning vector of the same type as \code{x}. Is used to update
counts following the change in values of the filtered dataset.
If it is set to \code{reactive(NULL)} then counts based on filtered
dataset are not shown.}

\item{\code{extract_type}}{(\code{character})
specifying whether condition calls should be prefixed by \code{dataname}. Possible values:
\itemize{
\item \code{character(0)} (default) \code{varname} in the condition call will not be prefixed
\item \code{"list"} \code{varname} in the condition call will be returned as \verb{<dataname>$<varname>}
\item \code{"matrix"} \code{varname} in the condition call will be returned as \verb{<dataname>[, <varname>]}
}}

\item{\code{slice}}{(\code{teal_slice})
specification of this filter state.
\code{teal_slice} is stored in the object and \code{set_state} directly manipulates values within \code{teal_slice}.
\code{get_state} returns \code{teal_slice} object which can be reused in other places.
Note that \code{teal_slice} is a \code{reactiveValues}, which means it has reference semantics, i.e.
changes made to an object are automatically reflected in all places that refer to the same \code{teal_slice}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Object of class \code{EmptyFilterState}, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EmptyFilterState-get_call"></a>}}
\if{latex}{\out{\hypertarget{method-EmptyFilterState-get_call}{}}}
\subsection{Method \code{get_call()}}{
Returns reproducible condition call for current selection relevant for selected variable type.
Uses internal reactive values, hence must be called in reactive or isolated context.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EmptyFilterState$get_call(dataname)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dataname}}{name of data set; defaults to \code{private$get_dataname()}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{logical(1)}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-EmptyFilterState-clone"></a>}}
\if{latex}{\out{\hypertarget{method-EmptyFilterState-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{EmptyFilterState$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
