% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FilteredDataset-utils.R
\name{init_filtered_dataset}
\alias{init_filtered_dataset}
\title{Initialize \code{FilteredDataset}}
\usage{
init_filtered_dataset(
  dataset,
  dataname,
  keys = character(0),
  parent_name = character(0),
  parent = reactive(dataset),
  join_keys = character(0),
  label = attr(dataset, "label")
)
}
\arguments{
\item{dataset}{any object}

\item{dataname}{(\code{character(1)})
syntactically valid name given to the dataset.}

\item{keys}{(\code{character})
optional vector of primary key column names.}

\item{parent_name}{(\code{character(1)})
name of the parent dataset.}

\item{parent}{(\code{reactive})
that returns a filtered \code{data.frame} from other \code{FilteredDataset} named \code{parent_name}.
Passing \code{parent} results in a \code{reactive} link that causes re-filtering of this \code{dataset}
based on the changes in \code{parent}.}

\item{join_keys}{(\code{character})
vector of names of columns in this dataset to join with \code{parent} dataset.
If column names in the parent do not match these, they should be given as the names of this vector.}

\item{label}{(\code{character(1)})
label to describe the dataset.}
}
\value{
Object of class \code{FilteredDataset}.
}
\description{
Initializes a \code{FilteredDataset} object corresponding to the class of the filtered dataset.
}
\section{Warning}{

This function is exported to allow other packages to extend \code{teal.slice} but it is treated as internal.
Breaking changes may occur without warning.
We recommend consulting the package maintainer before using it.
}

\examples{
# DataframeFilteredDataset example
library(shiny)

iris_fd <- init_filtered_dataset(iris, dataname = "iris")
ui <- fluidPage(
  iris_fd$ui_add(id = "add"),
  iris_fd$ui_active("dataset"),
  verbatimTextOutput("call")
)
server <- function(input, output, session) {
  iris_fd$srv_add(id = "add")
  iris_fd$srv_active(id = "dataset")

  output$call <- renderText({
    paste(
      vapply(iris_fd$get_call(), deparse1, character(1), collapse = "\n"),
      collapse = "\n"
    )
  })
}
if (interactive()) {
  shinyApp(ui, server)
}

\donttest{
if (requireNamespace("MultiAssayExperiment", quietly = TRUE)) {
  # MAEFilteredDataset example
  library(shiny)

  data(miniACC, package = "MultiAssayExperiment")

  MAE_fd <- init_filtered_dataset(miniACC, "MAE")
  ui <- fluidPage(
    MAE_fd$ui_add(id = "add"),
    MAE_fd$ui_active("dataset"),
    verbatimTextOutput("call")
  )
  server <- function(input, output, session) {
    MAE_fd$srv_add(id = "add")
    MAE_fd$srv_active(id = "dataset")
    output$call <- renderText({
      paste(
        vapply(MAE_fd$get_call(), deparse1, character(1), collapse = "\n"),
        collapse = "\n"
      )
    })
  }
  if (interactive()) {
    shinyApp(ui, server)
  }
}
}
}
\keyword{internal}
