% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teal_data.R
\name{teal_data}
\alias{teal_data}
\title{Comprehensive data integration function for \code{teal} applications}
\usage{
teal_data(..., join_keys = teal.data::join_keys(), code = character(0), check)
}
\arguments{
\item{...}{any number of objects (presumably data objects) provided as \code{name = value} pairs.}

\item{join_keys}{(\code{join_keys} or single \code{join_key_set})
optional object with datasets column names used for joining.
If empty then no joins between pairs of objects.}

\item{code}{(\code{character}, \code{language}) optional code to reproduce the datasets provided in \code{...}.
Note this code is not executed and the \code{teal_data} may not be reproducible}

\item{check}{(\code{logical}) \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
Use \code{\link[=verify]{verify()}} to verify code reproducibility .}
}
\value{
A \code{teal_data} object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Universal function to pass data to teal application.
}
\examples{
teal_data(x1 = iris, x2 = mtcars)

}
