% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/price.R
\name{get_price}
\alias{get_price}
\title{Quote Data Accessor for \sQuote{twelvedata}}
\usage{
get_price(
  sym,
  as = c("data.frame", "raw"),
  exchange = "",
  country = "",
  type = c(NA_character_, "Stock", "Index", "ETF", "REIT"),
  dp = 5,
  apikey
)
}
\arguments{
\item{sym}{(character) A (single or vector) symbol understood by the backend as a stock
symbol, foreign exchange pair, or more. See the \sQuote{twelvedata} documentation for
details on what is covered. In the case of a vector of arguments a vector or prices is returned.}

\item{as}{(optional, character) A selector for the desired output format: one of
\dQuote{data.frame} (the default) or or \dQuote{raw}.}

\item{exchange}{(optional, character) A selection of the exchange for which data for
\dQuote{sym} is requested, default value is unset.}

\item{country}{(optional, character) A selection of the country exchange for which data
for \dQuote{sym} is requested, default value is unset.}

\item{type}{(optional, character) A valid security type selection, if set it must be one of
\dQuote{Stock} (the default), \dQuote{Index}, \dQuote{ETF} or \dQuote{REIT}. Default is
unset via the \code{NA} character value. This field may require the premium subscription.}

\item{dp}{(optional, numeric) The number of decimal places returned on floating point
numbers. The value can be between 0 and 11, with a default value of 5.}

\item{apikey}{(optional character) An API key override, if missing a value cached from
package startup is used. The startup looks for either a file in the per-package config
directory provided by \code{tools::R_user_dir} (for R 4.0.0 or later), or the
\code{TWELVEDATA_API_KEY} variable.}
}
\value{
The requested data is returned.
}
\description{
Retrieve Securities Real-Time Price Data from \sQuote{twelvedata}
}
\details{
This is lightweight accessor which also returns the price. See \code{get_quote()} for a richer
return set.

The function has been named \code{get_price()} to be consistent with the \code{get_quote()}
function.
}
\seealso{
\url{https://twelvedata.com/docs}
}
\author{
Dirk Eddelbuettel
}
