% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sc2.R
\name{sc2}
\alias{sc2}
\title{Perform level 2  
single-concentration processing}
\usage{
sc2(ae, wr = FALSE)
}
\arguments{
\item{ae}{Integer of length 1, assay endpoint id (aeid) for processing.}

\item{wr}{Logical, whether the processed data should be written to the tcpl
database}
}
\value{
A boolean of length 1, indicating the success of the processing, or 
when 'wr' is FALSE, a list where the first element is a boolean indiciating 
the success of processing and the second element is a data.table containing 
the processed data
}
\description{
\code{sc2} loads level 1 data from the tcpl 
database for the given id and performs level 2 
single-concentration processing. 
The processed data is then loaded into the sc2 table and 
all subsequent data is deleted with \code{\link{tcplCascade}}. See details 
for more information.

The individual processing functions are no longer exported, as it is 
typically more convenient and suggested to use the \code{\link{tcplRun}} 
wrapper function.
}
\details{
Level 2 single-concentration processing defines the bmad value, and uses the
activity cutoff methods from sc2_aeid and sc2_methods to make an activity
call.
}
\seealso{
\code{\link{Method functions}}, \code{\link{SC2_Methods}}

Other single-concentration: 
\code{\link{sc1}()}
}
\concept{single-concentration}
