% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discr_test.R
\name{discr_test}
\alias{discr_test}
\title{Testing item discriminations}
\usage{
discr_test(X)
}
\arguments{
\item{X}{Data matrix.}
}
\value{
A list of test statistics, degrees of freedom, and p-values.
 \item{test}{A numeric vector of gradient (GR), likelihood ratio (LR), Rao score (RS), and Wald test statistics.}
 \item{df}{A numeric vector of corresponding degrees of freedom.}
 \item{pvalue}{A vector of corresponding p-values.}
 \item{call}{The matched call.}
}
\description{
Computes gradient (GR), likelihood ratio (LR), Rao score (RS) and Wald (W) test of
 hypothesis of equal item discriminations against the
  alternative that at least one item discriminates differently (only for binary data).
}
\details{
The tests are based on the following model suggested in Draxler, Kurz, Gürer, and Nolte (2022)

\deqn{ \text{logit} \big( E(Y) \big ) = \tau + \alpha + \delta (r - 1), }

where \eqn{E(Y)} ist the expected value of a binary response (of a person to an item),
\eqn{r = 1, \dots, k - 1} is the person score, i.e., number of correct responses of that person
when responding to \eqn{k} items, \eqn{\tau} is the respective person parameter and \eqn{\alpha} and
\eqn{\delta} are two parameters referring to the respective item. The parameter \eqn{\alpha}
represents a baseline, i.e., the easiness or attractiveness of the respective item in person score
group \eqn{r = 1}. The parameter \eqn{\delta} denotes the constant change of the attractiveness of that
item between successive person score groups. Thus, the model assumes a linear effect of the person
score \eqn{r} on the logit of the probability of a correct response.

The four test statistics are derived from a conditional likelihood function in which the
\eqn{\tau} parameters are eliminated by conditioning on the observed person scores.
The hypothesis to be tested is formally given by setting all \eqn{\delta} parameters equal to \eqn{0}.
The alternative assumes that at least one \eqn{\delta} parameter is not equal to \eqn{0}.
}
\examples{
\dontrun{
##### Dataset PISA Mathematics data.pisaMath {sirt} #####

library(sirt)
data(data.pisaMath)
y <- data.pisaMath$data[, grep(names(data.pisaMath$data), pattern = "M" )]

res <- discr_test(X = y)
# $test
# GR     LR     RS      W
# 72.430 73.032 76.725 73.470
#
# $df
# GR LR RS  W
# 10 10 10 10
#
# $pvalue
#       GR        LR        RS         W
# "< 0.001" "< 0.001" "< 0.001" "< 0.001"
#
# $call
# discr_test(X = y)

}
}
\references{
{
Draxler, C., Kurz. A., Gürer, C., & Nolte, J. P. (2022). An improved inferential procedure to evaluate item
discriminations in a conditional maximum likelihood framework. Manuscript submitted for publication.

 }
}
\seealso{
\code{\link{invar_test}}, \code{\link{change_test}}, and \code{\link{LLTM_test}}.
}
\keyword{htest}
