% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{plot.sim_tci}
\alias{plot.sim_tci}
\title{Plot method for sim_tci class}
\usage{
\method{plot}{sim_tci}(
  x,
  ...,
  yvar = NULL,
  id = NULL,
  type = c("true", "prior", "posterior"),
  show_inf = FALSE,
  show_data = FALSE,
  show_updates = FALSE,
  wrap_id = FALSE
)
}
\arguments{
\item{x}{Object with class "sim_tci" created by `simulate_tci()`}

\item{...}{Other arguments. Not currently used.}

\item{yvar}{Response variable. Options are concentrations ("c1","c2",...) or
"pdresp" for a PD response. Only one variable may be plotted at a time.}

\item{id}{Subset of IDs to plot. Will default to all if unspecified. Can be
displayed in separate plots via `wrap_id` argument.}

\item{type}{Type of response to plot. Options are "prior", "true", or "posterior"
if closed-loop control was used.}

\item{show_inf}{Logical. Display infusion rates alongside response values.}

\item{show_data}{Logical. Display simulated data values in addition to responses.}

\item{show_updates}{Logical, for closed-loop only. Show update times along x-axis.}

\item{wrap_id}{Logical. Separate plots by ID value.}
}
\value{
Plots simulation results
}
\description{
Plot object with class "sim_tci" created by `simulate_tci()`.
}
\examples{
data <- data.frame(ID = 1:2, AGE = c(30,40), TBW = c(70,80),
HGT = c(160,170), MALE = c(FALSE,TRUE))
pkmod_prior <- poppkmod(data, drug = "ppf", model = "eleveld")
pkmod_true  <- poppkmod(data, drug = "ppf", model = "eleveld", sample = TRUE)
obs_tms <- seq(1/6,10,1/6)
target_vals = c(75,60,50,50)
target_tms = c(0,3,6,10)

# open-loop simulation (without update_tms)
sim_ol <- simulate_tci(pkmod_prior, pkmod_true, target_vals, target_tms, obs_tms,
seed = 200)
plot(sim_ol, id = 1, type = "true")
plot(sim_ol, yvar = "c4", type = "true")
plot(sim_ol, yvar = "c4", type = "true", wrap_id = TRUE, show_inf = TRUE)

# closed-loop simulation (with update_tms)
\dontrun{
sim_cl <- simulate_tci(pkmod_prior, pkmod_true, target_vals, target_tms, obs_tms,
update_tms = c(2,4,6), seed = 200)
plot(sim_cl, type = "posterior", id = 1, show_inf = TRUE)
plot(sim_cl, type = "posterior", wrap_id = TRUE, show_data = TRUE)
plot(sim_cl, yvar = "c4", wrap_id = TRUE)
}
}
