% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post_bmr.R
\name{post_bmr}
\alias{post_bmr}
\title{Function post_bmr}
\usage{
post_bmr(nsims, weights_bmr)
}
\arguments{
\item{nsims}{The number of posterior simulations to draw.}

\item{weights_bmr}{An object of class 'tweights_bmr' created using the 'tweights_bmr' function.}
}
\value{
A matrix of simulations from the posterior.
}
\description{
Simulates the joint posterior based upon a dataset and specified marginal posterior distribution of the mean of selected variables.
}
\examples{
#Use winsorized marginal to keep marginal simulation within feasible bootstrap region
winsor=function(marginalSims,y)  {
  l=min(y)
  u=max(y)
  ifelse(marginalSims<l,l,ifelse(marginalSims>u,u, marginalSims))
}
#Create an example marginal posterior
marginal = list(Sepal.Length=winsor(rnorm(10000,mean=5.8, sd=.2),iris$Sepal.Length),
               Sepal.Width=winsor(rnorm(10000,mean=3,sd=.2), iris$Sepal.Width),
               Petal.Length=winsor(rnorm(10000,mean=3.7,sd=.2), iris$Petal.Length)
)

#simulate
w = tweights_bmr(dataset = iris, marginal = marginal, silent = TRUE)
post_sims = post_bmr(1000, weights = w)

}
\seealso{
\code{\link{tweights_bmr}}
}
