% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryBrlen.R
\name{summaryBrlen}
\alias{summaryBrlen}
\title{summaryBrlen: Summarise branch lengths on trees with identical topology}
\usage{
summaryBrlen(mphy, method)
}
\arguments{
\item{mphy}{An list of objects of class multiPhylo. If a single object in this
argument is of class multiPhylo, it is first enclosed in a list.}

\item{method}{A character with the function name for the summary to be applied}
}
\value{
A tree of class phylo with summary branch lengths in tree$edge.length.
}
\description{
summaryBrlen: Summarise branch lengths on trees with identical topology
}
\details{
This function can be used on the output of topofreq from the $trees element
in order to summarise the branch length on each topology set so that we have a single
tree summarising both topology and branch lengths. Useful for depicting posterior
tree density. Alternatively, it can be used with a single element provided that it is
first enclosed in a list
}
\examples{
\donttest{
set.seed(1)
library(ape)
trl <- ape::rmtree(10, 4)
tpf <- topoFreq(unroot(trl), output="trees")
sumtrees <- summaryBrlen(tpf$trees, method = "median")
oldpar <- par(no.readonly = TRUE)
par(mfrow=c(1,3))
plot(sumtrees[[1]], type="unrooted", show.node.label=FALSE, cex=1.5)
plot(sumtrees[[2]], type="unrooted", show.node.label=FALSE, cex=1.5)
plot(sumtrees[[3]], type="unrooted", show.node.label=FALSE, cex=1.5)
par(oldpar)
}

}
