% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_helper.R, R/tar_helper_raw.R
\name{tar_helper}
\alias{tar_helper}
\alias{tar_helper_raw}
\title{Write a helper R script.}
\usage{
tar_helper(path = NULL, code = NULL, tidy_eval = TRUE, envir = parent.frame())

tar_helper_raw(path = NULL, code = NULL)
}
\arguments{
\item{path}{Character of length 1, path to write (or overwrite) \code{code}.
If the parent directory does not exist, \code{tar_helper_raw()} creates it.
\code{tar_helper()} overwrites the file if it already exists.}

\item{code}{Code to write to \code{path}.
\code{\link[=tar_helper]{tar_helper()}} expects an unevaluated expression for the \code{code}
argument, whereas \code{\link[=tar_helper_raw]{tar_helper_raw()}} expects an evaluated
expression object.}

\item{tidy_eval}{Logical, whether to use tidy evaluation on \code{code}. If
turned on, you can substitute expressions and symbols using \verb{!!} and \verb{!!!}.
See examples below.}

\item{envir}{Environment for tidy evaluation.}
}
\value{
\code{NULL} (invisibly)
}
\description{
Write a helper R script for a \code{targets} pipeline.
Could be supporting functions or the target script file
(default: \verb{_targets.R}) itself.

\code{\link[=tar_helper]{tar_helper()}} expects an unevaluated expression for the \code{code}
argument, whereas \code{\link[=tar_helper_raw]{tar_helper_raw()}} expects an evaluated
expression object.
}
\details{
\code{tar_helper()} is a specialized version of \code{\link[=tar_script]{tar_script()}}
with flexible paths and tidy evaluation.
}
\examples{
# Without tidy evaluation:
path <- tempfile()
tar_helper(path, code = x <- 1)
tar_helper_raw(path, code = quote(x <- 1)) # equivalent
writeLines(readLines(path))
# With tidy evaluation:
y <- 123
tar_helper(path, x <- !!y)
writeLines(readLines(path))
}
\seealso{
Other scripts: 
\code{\link{tar_edit}()},
\code{\link{tar_github_actions}()},
\code{\link{tar_renv}()},
\code{\link{tar_script}()}
}
\concept{scripts}
