% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_progress_branches.R
\name{tar_progress_branches}
\alias{tar_progress_branches}
\title{Tabulate the progress of dynamic branches.}
\usage{
tar_progress_branches(names = NULL, fields = NULL)
}
\arguments{
\item{names}{Optional, names of the targets. If supplied, \code{tar_progress()}
only returns progress information on these targets.
You can supply symbols, a character vector,
or \code{tidyselect} helpers like \code{\link[=starts_with]{starts_with()}}.}

\item{fields}{Optional, names of progress data columns to read.
Set to \code{NULL} to read all fields.}
}
\value{
A data frame with one row per target per progress status
and the following columns.
\itemize{
\item \code{name}: name of the pattern.
\item \code{progress}: progress status: \code{"started"}, \code{"built"}, \code{"cancelled"},
or \code{"errored"}.
\item \code{branches}: number of branches in the progress category.
\item \code{total}: total number of branches planned for the whole pattern.
Values within the same pattern should all be equal.
}
}
\description{
Read a project's target progress data for the most recent
run of the pipeline and display the tabulated status
of dynamic branches. Only the most recent record is shown.
}
\examples{
if (identical(Sys.getenv("TAR_LONG_EXAMPLES"), "true")) {
tar_dir({ # tar_dir() runs code from a temporary directory.
tar_script({
  list(
    tar_target(x, seq_len(2)),
    tar_target(y, x, pattern = map(x)),
    tar_target(z, stopifnot(y < 1.5), pattern = map(y))
  )
}, ask = FALSE)
try(tar_make())
tar_progress_branches()
})
}
}
\seealso{
Other progress: 
\code{\link{tar_poll}()},
\code{\link{tar_progress_summary}()},
\code{\link{tar_progress}()},
\code{\link{tar_watch_server}()},
\code{\link{tar_watch_ui}()},
\code{\link{tar_watch}()}
}
\concept{progress}
