% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_manifest.R
\name{tar_manifest}
\alias{tar_manifest}
\title{Produce a data frame of information about your targets.}
\usage{
tar_manifest(
  names = NULL,
  fields = c("name", "command", "pattern"),
  callr_function = callr::r,
  callr_arguments = targets::callr_args_default(callr_function)
)
}
\arguments{
\item{names}{Names of the targets to show. Set to \code{NULL} to
show all the targets (default). Otherwise, you can supply
symbols, a character vector, or \code{tidyselect} helpers like \code{\link[=starts_with]{starts_with()}}.}

\item{fields}{Names of the fields, or columns, to show. Set to \code{NULL} to
show all the fields (default). Otherwise, you can supply
symbols, a character vector, or \code{tidyselect} helpers like \code{\link[=starts_with]{starts_with()}}.
Set to \code{NULL} to print all the fields.
The name of the target is always included as the first column
regardless of the selection.
Possible fields are below. All of them can be set in \code{\link[=tar_target]{tar_target()}},
\code{\link[=tar_target_raw]{tar_target_raw()}}, or \code{\link[=tar_option_set]{tar_option_set()}}.
\itemize{
\item \code{name}: Name of the target.
\item \code{command}: the R command that runs when the target builds.
\item \code{pattern}: branching pattern of the target, if applicable.
\item \code{format}: Storage format.
\item \code{iteration}: Iteration mode for branching.
\item \code{error}: Error mode, what to do when the target fails.
\item \code{memory}: Memory mode, when to keep targets in memory.
\item \code{storage}: Storage mode for high-performance computing scenarios.
\item \code{retrieval}: Retrieval mode for high-performance computing scenarios.
\item \code{deployment}: Where/whether to deploy the target in high-performance
computing scenarios.
\item \code{resources}: A list of target-specific resource requirements for
\code{\link[=tar_make_future]{tar_make_future()}}.
\item \code{cue_mode}: Cue mode from \code{\link[=tar_cue]{tar_cue()}}.
\item \code{cue_depend}: Depend cue from \code{\link[=tar_cue]{tar_cue()}}.
\item \code{cue_expr}: Command cue from \code{\link[=tar_cue]{tar_cue()}}.
\item \code{cue_file}: File cue from \code{\link[=tar_cue]{tar_cue()}}.
\item \code{cue_format}: Format cue from \code{\link[=tar_cue]{tar_cue()}}.
\item \code{cue_iteration}: Iteration cue from \code{\link[=tar_cue]{tar_cue()}}.
\item \code{packages}: List columns of packages loaded before building the target.
\item \code{library}: List column of library paths to load the packages.
}}

\item{callr_function}{A function from \code{callr} to start a fresh clean R
process to do the work. Set to \code{NULL} to run in the current session
instead of an external process (but restart your R session just before
you do in order to clear debris out of the global environment).
\code{callr_function} needs to be \code{NULL} for interactive debugging,
e.g. \code{tar_option_set(debug = "your_target")}.
However, \code{callr_function} should not be \code{NULL} for serious
reproducible work.}

\item{callr_arguments}{A list of arguments to \code{callr_function}.}
}
\value{
A data frame of information about the targets in the pipeline.
Rows appear in topological order (the order they will run
without any influence from parallel computing or priorities).
}
\description{
Along with \code{\link[=tar_visnetwork]{tar_visnetwork()}} and \code{\link[=tar_glimpse]{tar_glimpse()}},
\code{tar_manifest()} helps check that you constructed your pipeline correctly.
}
\examples{
if (identical(Sys.getenv("TAR_LONG_EXAMPLES"), "true")) {
tar_dir({ # tar_dir() runs code from a temporary directory.
tar_script({
  tar_option_set()
  list(
    tar_target(y1, 1 + 1),
    tar_target(y2, 1 + 1),
    tar_target(z, y1 + y2),
    tar_target(m, z, pattern = map(z)),
    tar_target(c, z, pattern = cross(z))
  )
}, ask = FALSE)
tar_manifest()
tar_manifest(fields = c("name", "command"))
tar_manifest(fields = "command")
tar_manifest(fields = starts_with("cue"))
})
}
}
