% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_exist_objects.R
\name{tar_exist_objects}
\alias{tar_exist_objects}
\title{Check if local output data exists for one or more targets.}
\usage{
tar_exist_objects(names, store = targets::tar_config_get("store"))
}
\arguments{
\item{names}{Character vector of target names.}

\item{store}{Character of length 1, path to the
\code{targets} data store. Defaults to \code{tar_config_get("store")},
which in turn defaults to \verb{_targets/}.
When you set this argument, the value of \code{tar_config_get("store")}
is temporarily changed for the current function call.
See \code{\link[=tar_config_get]{tar_config_get()}} and \code{\link[=tar_config_set]{tar_config_set()}} for details
about how to set the data store path persistently
for a project.}
}
\value{
Logical of length \code{length(names)}, whether
each given target has an existing file in \verb{_targets/objects/}
for the current project.
}
\description{
Check if the local data files exist in
\verb{_targets/objects/} for one or more targets.
}
\details{
To learn more about local storage in \code{targets}, visit
\url{https://books.ropensci.org/targets/files.html#internal-files}.
}
\examples{
tar_exist_objects(c("target1", "target2"))
}
\seealso{
Other existence: 
\code{\link{tar_exist_meta}()},
\code{\link{tar_exist_process}()},
\code{\link{tar_exist_progress}()},
\code{\link{tar_exist_script}()}
}
\concept{existence}
