% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_make_clustermq.R
\name{tar_make_clustermq}
\alias{tar_make_clustermq}
\title{Run a pipeline of targets in parallel with persistent
\code{clustermq} workers.}
\usage{
tar_make_clustermq(
  names = NULL,
  reporter = "verbose",
  workers = 1L,
  log_worker = FALSE,
  callr_function = callr::r,
  callr_arguments = list()
)
}
\arguments{
\item{names}{Names of the targets to build or check. Set to \code{NULL} to
check/build all the targets (default). Otherwise, you can supply
symbols, a character vector, or \code{tidyselect} helpers like \code{\link[=starts_with]{starts_with()}}.}

\item{reporter}{Character of length 1, name of the reporter to user.
Controls how messages are printed as targets run in the pipeline. Choices:
\itemize{
\item \code{"verbose"}: print one message for each target that runs (default).
\item \code{"silent"}: print nothing.
\item \code{"timestamp"}: print a time-stamped message for each target that runs.
\item \code{"summary"}: print a running total of the number of each targets in
each status category (queued, running, skipped, build, canceled,
or errored).
}}

\item{workers}{Positive integer, number of persistent \code{clustermq} workers
to create.}

\item{log_worker}{Logical, whether to write a log file for each worker.
Same as the \code{log_worker} argument of \code{clustermq::Q()}
and \code{clustermq::workers()}.}

\item{callr_function}{A function from \code{callr} to start a fresh clean R
process to do the work. Set to \code{NULL} to run in the current session
instead of an external process (but restart your R session just before
you do in order to clear debris out of the global environment).
\code{callr_function} needs to be \code{NULL} for interactive debugging,
e.g. \code{tar_option_set(debug = "your_target")}.
However, \code{callr_function} should not be \code{NULL} for serious
reproducible work.}

\item{callr_arguments}{A list of arguments to \code{callr_function}.}
}
\value{
\code{NULL} except if \code{callr_function = callr::r_bg()}, in which case
a handle to the \code{callr} background process is returned. Either way,
the value is invisibly returned.
}
\description{
This function is like \code{\link[=tar_make]{tar_make()}} except that targets
run in parallel with persistent \code{clustermq} workers. It requires
that you set global options like \code{clustermq.scheduler} and
\code{clustermq.template} inside the \verb{_targets.R} script.
\code{clustermq} is not a strict dependency of \code{targets},
so you must install \code{clustermq} yourself.
}
\details{
To use with a cluster, you will need to set the global options
\code{clustermq.scheduler} and \code{clustermq.template} inside \verb{_targets.R}.
To read more about configuring \code{clustermq} for your scheduler, visit
\url{https://mschubert.github.io/clustermq/articles/userguide.html#configuration} # nolint
and navigate to the appropriate link under "Setting up the scheduler".
Wildcards in the template file are filled in with elements from
\code{tar_option_get("resources")}.
}
\examples{
if (!identical(tolower(Sys.info()[["sysname"]]), "windows")) {
if (identical(Sys.getenv("TAR_LONG_EXAMPLES"), "true")) {
tar_dir({ # tar_dir() runs code from a temporary directory.
tar_script({
  options(clustermq.scheduler = "multicore") # Does not work on Windows.
  tar_option_set()
  list(tar_target(x, 1 + 1))
}, ask = FALSE)
tar_make_clustermq()
})
}
}
}
