% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tag2animal.R
\name{tag2animal}
\alias{tag2animal}
\title{Tag-frame to animal-frame conversion}
\usage{
tag2animal(X, sampling_rate, OTAB, Ya = NULL)
}
\arguments{
\item{X}{Data from a triaxial sensor such as an accelerometer, magnetometer or a gyroscope. X can be a three column matrix or a sensor structure (\strong{not} a data frame or tbl). In either case, X is in the tag frame, i.e., expressed in the canonical axes of the tag, not the animal. X can have any unit and any regular sampling rate (i.e., measurements are regularly sampled; equally spaced in time).}

\item{sampling_rate}{(optional) The sampling rate of the sensor data in Hz (samples per second). This is only needed if X is not a sensor structure. If X is a sensor data list, sampling_rate is obtained from its metadata (X$sampling_rate).}

\item{OTAB}{is a matrix defining the orientation of the tag on the animal as a function of time. Each row of OTAB is: \code{cue1, cue2, pitch, roll, heading}. (See \strong{Details}.)}

\item{Ya}{is an optional sensor structure in which the sensor data has already been
converted to the animal frame. The OTAB is extracted from this structure. This
is useful, for example, to replicate tag-to-animal conversions at different
sampling rates.}
}
\value{
Xa,the sensor data in the animal frame, i.e., rotated to correct for the tag
orientation on the animal. If X is a sensor structure, Xa will also be one. In this
case the structure elements 'frame' and 'name' will be changed. The OTAB will also
be added to the structure.
}
\description{
Convert tag frame measurements to animal frame using pre-determined tag orientation(s) on the animal.
}
\details{
This function uses the OTAB matrix to convert sensor data \code{X} from tag frame of reference to whale frame of reference.
Each row of OTAB is: \code{cue1, cue2, pitch, roll, heading}
where cue1 is the start time of a move in seconds with respect to the
start of X. cue2 is the end time of the move. If cue1 and cue2 are the
same, the move is instantaneous, otherwise a gradual move will be implemented
in which the orientation of the tag is linearly interpolated between the
previous and the new orientation.
The pitch, roll and heading angles describe the tag orientation on the
animal at the end of the move (angles are in radians).
The first row of OTAB must have cue1 and cue2 equal to 0 as this is the initial
orientation of the tag on the animal. Subsequent rows (if any) of OTAB describe
}
\examples{
Aw <- tag2animal(beaked_whale$A, OTAB = matrix(c(0,0,0.1, 0.04, -0.2), nrow = 1))

}
\seealso{
[prh_predictor1], [prh_predictor2]
}
