% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_nc.R
\name{save_nc}
\alias{save_nc}
\title{Save a tag dataset to a netCDF file.}
\usage{
save_nc(file, X, ...)
}
\arguments{
\item{file}{The name of the data and metadata file to be written. If \code{file} does not include a .nc suffix, this will be added automatically.}

\item{X}{An \code{animaltag} object, or a list of tag sensor and/or metadata lists. Alternatively, sensor and metadata lists may be input as multiple separate unnamed inputs. Only these kind of variables can be saved
in a NetCDF file because the supporting information in these structures is
needed to describe the contents of the file. For non-archive and non-portable
storage of variables, consider using \code{\link{save}} or various functions to write data to text files.}

\item{...}{Additional sensor or metadata lists, if user has not bundled them all into a list already but is providing individual structures.}
}
\value{
no return; saves a dataset to an nc file
}
\description{
This function saves a tag dataset to a netCDF file (this is an archival file format supported by the tagtools package and suitable for submission to online data archives).
}
\details{
Warning: this will overwrite any previous NetCDF file with the same name. The file is assumed to be in the current working directory unless \code{file} includes file path information.
}
\examples{
\dontshow{
.old_wd <- setwd(tempdir())
}
BW <- beaked_whale
save_nc("beaked_whale_test", BW)

\dontshow{
setwd(.old_wd)
}
}
