% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_cats.R
\name{read_cats}
\alias{read_cats}
\title{Read a CATS data file and convert to .nc}
\usage{
read_cats(fname, depid)
}
\arguments{
\item{fname}{is the file name of the CATS CSV file including the complete
path name if the file is not in the current working directory or in a
directory on the path. The .csv suffix is optional.}

\item{depid}{is a string containing the deployment identification code assigned
to this deployment, for example, 'mn12_186a'.}
}
\value{
A string (constructed by: '\code{depid}_raw.nc'; for example, 'mn12_186a_raw.nc') containing the file name of the netCDF (.nc) file in which the output has been saved. This function
generates a netCDF file in the current working directory containing
		the tag data variables, including:
		\itemize{
		\item {A, Accelerometer data structure}
		\item {M, Magnetometer data structure}
		\item {temp, Temperature sensor data structure}
		\item {info	Information structure for the deployment}
		}
}
\description{
Read a .csv file with data from a CATS tag deployment, including associated metadata, and store the resulting data in a .nc file.
}
\note{
CATS loggers can produce very large csv files which are slow to
process. This function is (somewhat) optimised for speed and memory use so will
tolerate large files. But processing could be slow. Note also that although CATs tags use a NED axis orientation for 3D sensors, 
this function converts to the NEU orientation expected by the animaltag tool kit. 
To revert (if continuing analysis with CATs-specific tools outside animaltags), 
simply multiply all z-axis values by -1. 
Also note that Cade et al. 2021 note that not all CATs tags have the same internal orientation of the triaxial sensors -- 
such that the first column in the data may or may not be the "x axis." 
Here, we assume that the three columns of data for any triaxial sensor are correctly labeled with X,Y,Z included in the column name in the CATs csv file. 
If not, further data-based bench calibration of the device may be needed to determine correct axis orientation.
}
\examples{
\dontrun{
nc_filename <- read_cats("my_cats_file.csv", "my_cats_deplyment_name")
load_nc("my_cats_deployment_name_raw.nc")
}
}
