% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effect_size.R
\name{effect_size_t}
\alias{effect_size_t}
\title{Simple Effect Size Calculation for t-Tests}
\usage{
effect_size_t(data, response, group, na.rm = TRUE)
}
\arguments{
\item{data}{A \code{data.frame}.}

\item{response}{The response variable (dependent).}

\item{group}{The group variable, usually a \code{factor}.}

\item{na.rm}{If \code{TRUE} (default), missing values are dropped.}
}
\value{
\code{numeric} of length 1.
}
\description{
Simple Effect Size Calculation for t-Tests
}
\examples{
df <- data.frame(x = runif(100), y = sample(c("A", "B"), 100, TRUE))
effect_size_t(df, "x", "y")
}

