% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tadaa_stats.R
\name{tadaa_one_sample}
\alias{tadaa_one_sample}
\title{Tadaa, one-sample tests!}
\usage{
tadaa_one_sample(data = NULL, x, mu, sigma = NULL,
  direction = "two.sided", na.rm = TRUE, print = "df")
}
\arguments{
\item{data}{A \code{data.frame}.}

\item{x}{A numeric vector.}

\item{mu}{The true mean (\eqn{\mu}) to test for.}

\item{sigma}{Population sigma. If supplied, a z-test is performed,
else a one-sample \link[stats]{t.test} is performed.}

\item{direction}{Test direction, like \code{alternative} in \link{t.test}.}

\item{na.rm}{If \code{TRUE} (default), missing values are dropped.}

\item{print}{Print method, per default a regular \code{data.frame}.
Otherwise passed to \link[pixiedust]{sprinkle_print_method} for fancyness.}
}
\value{
A \code{data.frame} by default, otherwise \code{dust} object, depending on \code{print}.
}
\description{
If `sigma` is omitted, the function will basically just perform a one-sample \link[stats]{t.test},
but if `sigma` is provided, a z-test is performed. It basically works the same way, except that we
pretend we know the population sigma.
}
\examples{
df <- data.frame(x = rnorm(n = 20, mean = 100, sd = 1))

tadaa_one_sample(df, x, mu = 101, sigma = 1)

# No data.frame, just a vector
tadaa_one_sample(x = rnorm(20), mu = 0)
}
\seealso{
Other Tadaa-functions: \code{\link{tadaa_aov}},
  \code{\link{tadaa_kruskal}}, \code{\link{tadaa_nom}},
  \code{\link{tadaa_normtest}}, \code{\link{tadaa_ord}},
  \code{\link{tadaa_t.test}}, \code{\link{tadaa_wilcoxon}}
}
