% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot2_themes.R
\name{theme_readthedown}
\alias{theme_readthedown}
\title{ggplot2 theme to fit the readthedown Rmd format}
\usage{
theme_readthedown(base_size = 12, base_family = "", bg = "#fcfcfc",
  axis_emph = "xy")
}
\arguments{
\item{base_size}{Base text size, defaults to \code{12}.}

\item{base_family}{Base text family. Use \code{"Roboto Slab"} to match the \code{readthedown}
headers, or \code{"Lato"} for the body style.}

\item{bg}{Background color, defaults to \code{\link[rmdformats]{readthedown}}'s background,
\code{#fcfcfc}}

\item{axis_emph}{Which axis to emphasize visually (black lines). One of \code{"x", "y", "xy"}.}
}
\value{
A ggplot2 theme
}
\description{
A ggplot theme to fit \code{\link[rmdformats]{readthedown}} in terms of background color and
dark grid lines.
}
\examples{
\dontrun{
library(ggplot2)
p <- qplot(1:10, 1:10, geom = "point")

p + theme_readthedown()
p + theme_readthedown(base_family = "Lato")
p + theme_readthedown(base_family = "Roboto Slab", axis_emph = "x")
}
}

