/*
 * Decompiled with CFR 0.152.
 */
package technology.tabula;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.pdfbox.text.TextPosition;
import technology.tabula.RectangleSpatialIndex;
import technology.tabula.TextElement;
import technology.tabula.Utils;

public class TextStripper
extends PDFTextStripper {
    private static final String NBSP = "\u00a0";
    private PDDocument document;
    public ArrayList<TextElement> textElements;
    public RectangleSpatialIndex<TextElement> spatialIndex;
    public float minCharWidth = Float.MAX_VALUE;
    public float minCharHeight = Float.MAX_VALUE;

    public TextStripper(PDDocument document, int pageNumber) throws IOException {
        this.document = document;
        this.setStartPage(pageNumber);
        this.setEndPage(pageNumber);
        this.textElements = new ArrayList();
        this.spatialIndex = new RectangleSpatialIndex();
    }

    public void process() throws IOException {
        this.getText(this.document);
    }

    @Override
    protected void writeString(String string, List<TextPosition> textPositions) throws IOException {
        for (TextPosition textPosition : textPositions) {
            String c;
            if (textPosition == null || !this.isPrintable(c = textPosition.getUnicode())) continue;
            Float h = Float.valueOf(textPosition.getHeightDir());
            if (c.equals(NBSP)) {
                c = " ";
            }
            float wos = textPosition.getWidthOfSpace();
            TextElement te = new TextElement(Utils.round(textPosition.getYDirAdj() - h.floatValue(), 2), Utils.round(textPosition.getXDirAdj(), 2), Utils.round(textPosition.getWidthDirAdj(), 2), Utils.round(textPosition.getHeightDir(), 2), textPosition.getFont(), textPosition.getFontSize(), c, wos, textPosition.getDir());
            this.minCharWidth = (float)Math.min((double)this.minCharWidth, te.getWidth());
            this.minCharHeight = (float)Math.min((double)this.minCharHeight, te.getHeight());
            this.spatialIndex.add(te);
            this.textElements.add(te);
        }
    }

    private boolean isPrintable(String s) {
        boolean printable = false;
        for (int i = 0; i < s.length(); ++i) {
            Character c = Character.valueOf(s.charAt(i));
            Character.UnicodeBlock block = Character.UnicodeBlock.of(c.charValue());
            printable |= !Character.isISOControl(c.charValue()) && block != null && block != Character.UnicodeBlock.SPECIALS;
        }
        return printable;
    }
}

