% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/index_richness.R
\docType{methods}
\name{richness}
\alias{richness}
\alias{richness-method}
\alias{composition}
\alias{composition-method}
\alias{index_ace}
\alias{index_ace-method}
\alias{index_ice}
\alias{index_ice-method}
\alias{index_chao1}
\alias{index_chao1-method}
\alias{index_chao2}
\alias{index_chao2-method}
\alias{index_margalef}
\alias{index_margalef-method}
\alias{index_menhinick}
\alias{index_menhinick-method}
\alias{richness,matrix-method}
\alias{richness,data.frame-method}
\alias{composition,matrix-method}
\alias{composition,data.frame-method}
\alias{index_margalef,numeric-method}
\alias{index_menhinick,numeric-method}
\alias{index_ace,numeric-method}
\alias{index_chao1,numeric-method}
\alias{index_ice,matrix-method}
\alias{index_chao2,matrix-method}
\title{Richness}
\usage{
richness(object, ...)

composition(object, ...)

index_ace(x, ...)

index_ice(x, ...)

index_chao1(x, ...)

index_chao2(x, ...)

index_margalef(x, ...)

index_menhinick(x, ...)

\S4method{richness}{matrix}(object, method = c("count", "margalef", "menhinick"))

\S4method{richness}{data.frame}(object, method = c("count", "margalef", "menhinick"))

\S4method{composition}{matrix}(
  object,
  method = c("chao1", "ace", "chao2", "ice"),
  unbiased = FALSE,
  improved = FALSE,
  k = 10
)

\S4method{composition}{data.frame}(
  object,
  method = c("chao1", "ace", "chao2", "ice"),
  unbiased = FALSE,
  improved = FALSE,
  k = 10
)

\S4method{index_margalef}{numeric}(x, na.rm = FALSE, ...)

\S4method{index_menhinick}{numeric}(x, na.rm = FALSE, ...)

\S4method{index_ace}{numeric}(x, k = 10, ...)

\S4method{index_chao1}{numeric}(x, unbiased = FALSE, improved = FALSE, ...)

\S4method{index_ice}{matrix}(x, k = 10, ...)

\S4method{index_chao2}{matrix}(x, unbiased = FALSE, improved = FALSE, ...)
}
\arguments{
\item{object}{A \eqn{m \times p}{m x p} \code{numeric} \code{\link{matrix}} or
\code{\link{data.frame}} of count data (absolute frequencies).}

\item{...}{Further arguments to be passed to internal methods.}

\item{x}{A \code{\link{numeric}} vector or matrix of count data (absolute frequencies).}

\item{method}{A \code{\link{character}} string or vector of strings specifying the
index to be computed (see details). Any unambiguous substring can be given.}

\item{unbiased}{A \code{\link{logical}} scalar. Should the bias-corrected estimator be
used? Only used with "\code{chao1}" or "\code{chao2}" (improved) estimator.}

\item{improved}{A \code{\link{logical}} scalar. Should the improved estimator be used?
Only used with "\code{chao1}" or "\code{chao2}".}

\item{k}{A length-one \code{\link{numeric}} vector giving the threshold between
rare/infrequent and abundant/frequent species. Only used if \code{method} is
"\code{ace}" or "\code{ice}".}

\item{na.rm}{A \code{\link{numeric}} scalar: should missing values (including \code{NaN}) be
removed?}
}
\value{
\itemize{
\item \code{richness()} returns a \linkS4class{RichnessIndex} object.
\item \code{composition()} returns a \linkS4class{CompositionIndex} object.
\item \verb{index_*()} return a \code{\link{numeric}} vector.
}
}
\description{
\itemize{
\item \code{richness()} returns sample richness.
\item \code{composition()} returns asymptotic species richness.
}
}
\section{Details}{

The number of different taxa, provides an instantly comprehensible
expression of diversity. While the number of taxa within a sample
is easy to ascertain, as a term, it makes little sense: some taxa
may not have been seen, or there may not be a fixed number of taxa
(e.g. in an open system; Peet 1974). As an alternative, \emph{richness}
(\eqn{S}) can be used for the concept of taxa number (McIntosh 1967).

It is not always possible to ensure that all sample sizes are equal
and the number of different taxa increases with sample size and
sampling effort (Magurran 1988). Then, \emph{rarefaction} (\eqn{E(S)}) is
the number of taxa expected if all samples were of a standard size (i.e.
taxa per fixed number of individuals). Rarefaction assumes that imbalances
between taxa are due to sampling and not to differences in actual
abundances.
}

\section{Richness Measures}{

The following richness measures are available for count data:
\describe{
\item{\code{count}}{Returns the number of observed taxa/types.}
\item{\code{margalef}}{Margalef richness index.}
\item{\code{menhinick}}{Menhinick richness index.}
}
}

\section{Asymptotic Species Richness}{

The following measures are available for count data:
\describe{
\item{\code{ace}}{Abundance-based Coverage Estimator.}
\item{\code{chao1}}{(improved/unbiased) Chao1 estimator.}
}

The following measures are available for replicated incidence data:
\describe{
\item{\code{ice}}{Incidence-based Coverage Estimator.}
\item{\code{chao2}}{(improved/unbiased) Chao2 estimator.}
}
}

\examples{
## Richness
## Margalef and Menhinick index
## Data from Magurran 1988, p. 128-129
trap <- matrix(data = c(9, 3, 0, 4, 2, 1, 1, 0, 1, 0, 1, 1,
                        1, 0, 1, 0, 0, 0, 1, 2, 0, 5, 3, 0),
               nrow = 2, byrow = TRUE, dimnames = list(c("A", "B"), NULL))
richness(trap, method = "margalef") # 2.55 1.88
richness(trap, method = "menhinick") # 1.95 1.66

## Asymptotic species richness
## Chao1-type estimators
## Data from Chao & Chiu 2016
brazil <- matrix(
  data = rep(x = c(1:21, 23, 25, 27, 28, 30, 32, 34:37, 41,
                   45, 46, 49, 52, 89, 110, 123, 140),
             times = c(113, 50, 39, 29, 15, 11, 13, 5, 6, 6, 3, 4,
                       3, 5, 2, 5, 2, 2, 2, 2, 1, 2, 1, 1, 1, 1, 1,
                       0, 0, 2, 1, 1, 1, 1, 1, 0, 1, 1, 0, 0)),
  nrow = 1, byrow = TRUE
)

composition(brazil, method = c("chao1"), unbiased = FALSE) # 461.625
composition(brazil, method = c("ace"), k = 10) # 445.822

## Rarefaction
rarefaction(trap, sample = 13) # 6.56 6.00
}
\references{
Chao, A. (1984). Nonparametric Estimation of the Number of Classes in a
Population. \emph{Scandinavian Journal of Statistics}, 11(4), 265-270.

Chao, A. (1987). Estimating the Population Size for Capture-Recapture Data
with Unequal Catchability. \emph{Biometrics} 43(4), 783-791.
\doi{10.2307/2531532}.

Chao, A. & Chiu, C.-H. (2016). Species Richness: Estimation and Comparison.
\emph{In} Balakrishnan, N., Colton, T., Everitt, B., Piegorsch, B., Ruggeri,
F. & Teugels, J. L. (Eds.), \emph{Wiley StatsRef: Statistics Reference Online}.
Chichester, UK: John Wiley & Sons, Ltd., 1-26.
\doi{10.1002/9781118445112.stat03432.pub2}

Chao, A. & Lee, S.-M. (1992). Estimating the Number of Classes via Sample
Coverage. \emph{Journal of the American Statistical Association}, 87(417),
210-217. \doi{10.1080/01621459.1992.10475194}.

Chiu, C.-H., Wang, Y.-T., Walther, B. A. & Chao, A. (2014). An improved
nonparametric lower bound of species richness via a modified good-turing
frequency formula. \emph{Biometrics}, 70(3), 671-682.
\doi{10.1111/biom.12200}.

Magurran, A. E. (1988). \emph{Ecological Diversity and its Measurement}.
Princeton, NJ: Princeton University Press. \doi{10.1007/978-94-015-7358-0}.

Kintigh, K. W. (1989). Sample Size, Significance, and Measures of
Diversity. In Leonard, R. D. and Jones, G. T., \emph{Quantifying Diversity
in Archaeology}. New Directions in Archaeology. Cambridge:
Cambridge University Press, p. 25-36.

Magurran, A E. & Brian J. McGill (2011). \emph{Biological Diversity:
Frontiers in Measurement and Assessment}. Oxford: Oxford University Press.

Margalef, R. (1958). Information Theory in Ecology. \emph{General Systems},
3, 36-71.

Menhinick, E. F. (1964). A Comparison of Some Species-Individuals Diversity
Indices Applied to Samples of Field Insects. \emph{Ecology}, 45(4), 859-861.
\doi{10.2307/1934933}.

McIntosh, R. P. (1967). An Index of Diversity and the Relation of Certain
Concepts to Diversity. \emph{Ecology}, 48(3), 392-404.
\doi{10.2307/1932674}.
}
\seealso{
\code{\link[=plot_diversity]{plot_diversity()}}

Other diversity measures: 
\code{\link{heterogeneity}()},
\code{\link{occurrence}()},
\code{\link{plot_diversity}},
\code{\link{rarefaction}()},
\code{\link{similarity}()},
\code{\link{simulate}()},
\code{\link{turnover}()}
}
\author{
N. Frerebeau
}
\concept{diversity measures}
