% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{stats_bootstrap}
\alias{stats_bootstrap}
\title{Bootstrap Estimation}
\usage{
stats_bootstrap(x, do, probs = c(0.05, 0.95), n = 1000, na.rm = FALSE, ...)
}
\arguments{
\item{x}{A vector.}

\item{do}{A \code{\link{function}} that takes \code{x} as an argument
and returns a single numeric value.}

\item{probs}{A \code{\link{numeric}} vector of probabilities with values in
\eqn{[0,1]} (see \code{\link[stats:quantile]{quantile}}).}

\item{n}{A non-negative \code{\link{integer}} giving the number of bootstrap
replications.}

\item{na.rm}{A \code{\link{logical}} scalar: should missing values be removed
from \code{x} before the quantiles are computed?}

\item{...}{Extra arguments passed to \code{do}.}
}
\value{
A \code{numeric} vector with the following elements:
 \describe{
  \item{min}{Minimum value.}
  \item{mean}{Mean value.}
  \item{max}{Maximum value.}
  \item{Q*}{Sample quantile to * probability.}
 }
}
\description{
Bootstrap Estimation
}
\keyword{internal}
