% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/deprecate.R, R/mutators.R,
%   R/permute.R, R/refine_ca.R, R/seriate_average.R, R/seriate_rank.R
\docType{methods}
\name{seriation}
\alias{seriation}
\alias{seriate_average}
\alias{seriate_average-method}
\alias{seriate_rank}
\alias{seriate_rank-method}
\alias{permute}
\alias{permute-method}
\alias{refine_seriation}
\alias{refine_seriation-method}
\alias{seriate_correspondence,CountMatrix-method}
\alias{seriate_correspondence,IncidenceMatrix-method}
\alias{get_order,PermutationOrder-method}
\alias{permute,CountMatrix,PermutationOrder-method}
\alias{permute,IncidenceMatrix,PermutationOrder-method}
\alias{refine_seriation,CA-method}
\alias{seriate_average,CountMatrix-method}
\alias{seriate_average,IncidenceMatrix-method}
\alias{seriate_rank,CountMatrix-method}
\alias{seriate_rank,IncidenceMatrix-method}
\title{Matrix Seriation}
\usage{
seriate_average(object, ...)

seriate_rank(object, ...)

permute(object, order, ...)

refine_seriation(object, ...)

\S4method{seriate_correspondence}{CountMatrix}(object, margin = c(1, 2), ...)

\S4method{seriate_correspondence}{IncidenceMatrix}(object, margin = c(1, 2), ...)

\S4method{get_order}{PermutationOrder}(x)

\S4method{permute}{CountMatrix,PermutationOrder}(object, order)

\S4method{permute}{IncidenceMatrix,PermutationOrder}(object, order)

\S4method{refine_seriation}{CA}(
  object,
  cutoff,
  n = 1000,
  axes = c(1, 2),
  progress = getOption("tabula.progress"),
  ...
)

\S4method{seriate_average}{CountMatrix}(object, margin = c(1, 2), axes = 1, ...)

\S4method{seriate_average}{IncidenceMatrix}(object, margin = c(1, 2), axes = 1, ...)

\S4method{seriate_rank}{CountMatrix}(object, EPPM = FALSE, margin = c(1, 2), stop = 100)

\S4method{seriate_rank}{IncidenceMatrix}(object, margin = c(1, 2), stop = 100)
}
\arguments{
\item{object, x}{An \eqn{m \times p}{m x p} data matrix (typically an object
of class \linkS4class{CountMatrix} or \linkS4class{IncidenceMatrix}.}

\item{...}{Further arguments to be passed to internal methods.}

\item{order}{A \linkS4class{PermutationOrder} object giving the permutation
order for rows and columns.}

\item{margin}{A \code{\link{numeric}} vector giving the subscripts which the
rearrangement will be applied over: \code{1} indicates rows, \code{2}
indicates columns, \code{c(1, 2)} indicates rows then columns,
\code{c(2, 1)} indicates columns then rows.}

\item{cutoff}{A function that takes a numeric vector as argument and returns
a single numeric value (see below).}

\item{n}{A non-negative \code{\link{integer}} giving the number of bootstrap
replications.}

\item{axes}{An \code{\link{integer}} vector giving the subscripts of the CA
axes to be used.}

\item{progress}{A \code{\link{logical}} scalar: should a progress bar be
displayed?}

\item{EPPM}{A \code{\link{logical}} scalar: should the seriation be computed
on EPPM instead of raw data?}

\item{stop}{An \code{\link{integer}} giving the stopping rule
(i.e. maximum number of iterations) to avoid infinite loop.}
}
\value{
\code{seriate_*} returns a \linkS4class{PermutationOrder} object.

 \code{refine_seriation} returns a \linkS4class{RefineCA} object.

 \code{permute} returns either a permuted \linkS4class{CountMatrix} or an
 \linkS4class{IncidenceMatrix} (the same as \code{object}).
}
\description{
* \code{seriate_*} computes a permutation order for rows and/or columns.
 * \code{permute} rearranges a data matrix according to a permutation order.
 * \code{get_order} returns the seriation order for rows and columns.
}
\note{
Refining method can lead to much longer execution times and larger output
 objects.
}
\section{Seriation}{

 The matrix seriation problem in archaeology is based on three conditions
 and two assumptions, which Dunell (1970) summarizes as follows.

 The homogeneity conditions state that all the groups included in a
 seriation must:
 \enumerate{
  \item{Be of comparable duration.}
  \item{Belong to the same cultural tradition.}
  \item{Come from the same local area.}
 }

 The mathematical assumptions state that the distribution of any historical
 or temporal class:
 \enumerate{
  \item{Is continuous through time.}
  \item{Exhibits the form of a unimodal curve.}
 }
 Theses assumptions create a distributional model and ordering is
 accomplished by arranging the matrix so that the class distributions
 approximate the required pattern. The resulting order is inferred
 to be chronological.

 The following seriation methods are available:
 \describe{
  \item{\code{seriate_average}}{Correspondence analysis-based seriation
  (average ranking). Correspondence analysis (CA) is an effective method for
  the seriation of archaeological assemblages. The order of the rows and
  columns is given by the coordinates along one dimension of the CA space,
  assumed to account for temporal variation. The direction of temporal change
  within the correspondence analysis space is arbitrary: additional
  information is needed to determine the actual order in time.}
  \item{\code{seriate_rank}}{Reciprocal ranking seriation. These procedures
  iteratively rearrange rows and/or columns according to their weighted rank
  in the data matrix until convergence.
  Note that this procedure could enter into an infinite loop.
  If no convergence is reached before the maximum number of iterations, it
  stops with a warning.}
 }
}

\section{Correspondence Analysis}{

 \code{refine_seriation} allows to identify samples that are subject to
 sampling error or samples that have underlying structural relationships
 and might be influencing the ordering along the CA space.

 This relies on a partial bootstrap approach to CA-based seriation where each
 sample is replicated \code{n} times. The maximum dimension length of
 the convex hull around the sample point cloud allows to remove samples for
 a given \code{cutoff} value.

 According to Peebles and Schachner (2012), "[this] point removal procedure
 [results in] a reduced dataset where the position of individuals within the
 CA are highly stable and which produces an ordering consistent with the
 assumptions of frequency seriation."
}

\examples{
## Replicates Desachy 2004 results
## Coerce dataset to abundance matrix
data("compiegne", package = "folio")
compiegne_count <- as_count(compiegne)

## Get seriation order for columns on EPPM using the reciprocal averaging method
## Expected column order: N, A, C, K, P, L, B, E, I, M, D, G, O, J, F, H
(compiegne_indices <- seriate_rank(compiegne_count, EPPM = TRUE, margin = 2))

## Permute columns
compiegne_new <- permute(compiegne_count, compiegne_indices)

## Plot new matrix
plot_ford(compiegne_new, EPPM = FALSE)

## See the vignette:
\dontrun{
utils::vignette("seriation")
}
}
\references{
Desachy, B. (2004). Le sériographe EPPM: un outil informatisé de sériation
 graphique pour tableaux de comptages. \emph{Revue archéologique de
 Picardie}, 3(1), 39-56. \doi{10.3406/pica.2004.2396}.

 Dunnell, R. C. (1970). Seriation Method and Its Evaluation. \emph{American
 Antiquity}, 35(03), 305-319. \doi{10.2307/278341}.

 Ihm, P. (2005). A Contribution to the History of Seriation in Archaeology.
 In C. Weihs & W. Gaul (Eds.), \emph{Classification: The Ubiquitous
 Challenge}. Berlin Heidelberg: Springer, p. 307-316.
 \doi{10.1007/3-540-28084-7_34}.

 Peeples, M. A., & Schachner, G. (2012). Refining correspondence
 analysis-based ceramic seriation of regional data sets. \emph{Journal of
 Archaeological Science}, 39(8), 2818-2827.
 \doi{10.1016/j.jas.2012.04.040}.
}
\seealso{
\link{refine_seriation}, \link[dimensio]{ca}
}
\author{
N. Frerebeau
}
\concept{seriation}
