% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{DiversityIndex}
\alias{DiversityIndex}
\alias{DiversityIndex-class}
\alias{.DiversityIndex}
\alias{HeterogeneityIndex-class}
\alias{.HeterogeneityIndex}
\alias{HeterogeneityIndex}
\alias{EvennessIndex-class}
\alias{.EvennessIndex}
\alias{EvennessIndex}
\alias{RichnessIndex-class}
\alias{.RichnessIndex}
\alias{RichnessIndex}
\title{Diversity Index}
\description{
An S4 class to represent a diversity measure.
}
\section{Slots}{

\describe{
\item{\code{id}}{A \code{\link{character}} string specifying the unique
identifier of the corresponding matrix (UUID v4).}

\item{\code{index}}{A \code{\link{numeric}} vector giving the diversity index values.}

\item{\code{size}}{A \code{\link{integer}} vector giving the sample sizes.}

\item{\code{jackknife}}{A numeric \code{\link{matrix}} vector giving the jackknifed
estimates.}

\item{\code{boostrap}}{A numeric \code{\link{matrix}} vector giving the boostraped
estimates.}

\item{\code{simulated}}{A numeric \code{\link{matrix}} vector giving the diversity
measures for the simulated assemblage.}

\item{\code{method}}{A \code{\link{character}} string indicating the method used.}
}}

\section{Subset}{

 In the code snippets below, \code{x} is a \code{DiversityIndex} object.
 \describe{
  \item{\code{x[[i]]}}{Extracts informations from a slot selected by
  subscript \code{i}. \code{i} is a length-one \code{\link{character}}
  vector. Returns the corresponding slot values.}
 }
}

\seealso{
Other class: \code{\link{BootCA-class}},
  \code{\link{DateModel-class}},
  \code{\link{PermutationOrder-class}}
}
\author{
N. Frerebeau
}
\concept{class}
