% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{BootCA-class}
\alias{BootCA-class}
\alias{[[,BootCA-method}
\alias{rows,BootCA-method}
\alias{columns,BootCA-method}
\title{Partial bootstrap CA}
\usage{
\S4method{[[}{BootCA}(x, i)

\S4method{rows}{BootCA}(x)

\S4method{columns}{BootCA}(x)
}
\arguments{
\item{x}{A \code{BootCA} object from which to extract element(s).}

\item{i}{A \code{\link{character}} string specifying elements to extract.
Character vectors will be matched to the name of the slots.}
}
\description{
An S4 class to store partial bootstrap correspondance analysis results.
}
\section{Methods (by generic)}{
\itemize{
\item \code{[[}: Returns information about the individual slots.

\item \code{rows}: Returns the convex hull vertice coordinates for each
individual.

\item \code{columns}: Returns the convex hull vertice coordinates for each
variable.
}}

\section{Slots}{

\describe{
\item{\code{rows}}{A three columns \code{\link{data.frame}} giving the vertices
coordinates of the samples convex hull and a identifier to link each row to
a sample.}

\item{\code{columns}}{A three columns \code{\link{data.frame}} giving the vertices
coordinates of the variables convex hull and a identifier to link each row
to a variable.}

\item{\code{lengths}}{A \code{\link{numeric}} vector giving the convex hull
maximum dimension length of each sample.}

\item{\code{cutoff}}{A length-one \code{\link{numeric}} vector giving the cutoff
value for sample selection.}

\item{\code{keep}}{A named \code{\link{numeric}} vector giving the subscript of
the samples to be kept.}
}}

\author{
N. Frerebeau
}
