#' Compiegne ceramics
#'
#' A dataset containing the ceramic counts from the Place des Hallettes in
#'  Compiègne (Oise, France). The data are grouped into five periods of about a
#'  century, ranging from the 9th to the 14th century, and sixteen ceramic
#'  types.
#' @format A numeric matrix with 5 rows (chronological periods, numbered from
#'  the oldest to the most recent from 1 to 5) and 16 variables (ceramic types):
#'  \describe{
#'   \item{A}{Red to white ceramics with fine sized inclusions.}
#'   \item{B}{Red to white ceramics with medium sized inclusions.}
#'   \item{C}{Dark ceramics with fine sized inclusions.}
#'   \item{D}{Dark ceramics with medium sized inclusions.}
#'   \item{E}{Ceramics close to those of groups B or D, with similarities to
#'   group F.}
#'   \item{F}{Black, red or beige ceramics with coarse inclusions.}
#'   \item{G}{Red polished ceramics with fine to medium sized inclusions.}
#'   \item{H}{Black polished ceramics with fine sized inclusions.}
#'   \item{I}{Black polished ceramics with medium sized inclusions.}
#'   \item{J}{Polished and painted ceramics with fine to medium sized
#'   inclusions.}
#'   \item{K}{Painted ceramics, similar to those of group A.}
#'   \item{L}{Painted ceramics, similar to those of group B.}
#'   \item{M}{Painted ceramics with coarse inclusions.}
#'   \item{N}{Glazed ceramics.}
#'   \item{O}{Stamped ceramics.}
#'   \item{P}{Coated ceramics.}
#'  }
#' @source
#'  Lacroix, M. C. (1997). La céramique médiévale du site des Hallettes à
#'  Compiègne (Oise). \emph{Revue archéologique de Picardie}. Numéro spécial,
#'  13(1), 135-168.
#'  DOI: \href{https://doi.org/10.3406/pica.1997.1945}{10.3406/pica.1997.1945}
"compiegne"

#' Boves ceramics
#'
#' A dataset containing the ceramic counts from the castle site of Boves
#'  (Somme, France). The data are grouped into eight periods ranging from the
#'  10th to the 18th century and thirteen ceramic types.
#' @format A numeric matrix with 8 rows and 13 variables:
#'  \describe{
#'    \item{I}{}
#'    \item{IIa}{}
#'    \item{IIb}{}
#'    \item{IIIa}{}
#'    \item{IIIb}{}
#'    \item{IIIc}{}
#'    \item{IVa}{}
#'    \item{IVb}{}
#'    \item{Va}{}
#'    \item{Vb}{}
#'    \item{VI}{}
#'    \item{VII}{}
#'  }
#' @source
#'  Racinet P. (2002). Le site castral et prioral de Boves du Xe au XVIIe
#'  siècle. Bilan des recherches 1996-2000. \emph{Revue archéologique de
#'  Picardie}. Numéro spécial 20, 123 p.
"boves"

#' Zuni ceramics
#'
#' A dataset containing ceramic counts from the Zuni region of the American
#' Southwest.
#' @format A numeric matrix with 420 rows and 18 variables:
#'  \describe{
#'    \item{LINO}{}
#'    \item{KIAT}{}
#'    \item{RED}{}
#'    \item{GALL}{}
#'    \item{ESC}{}
#'    \item{PUBW}{}
#'    \item{RES}{}
#'    \item{TULA}{}
#'    \item{PINE}{}
#'    \item{PUBR}{}
#'    \item{WING}{}
#'    \item{WIPO}{}
#'    \item{SJ}{}
#'    \item{LSJ}{}
#'    \item{SPR}{}
#'    \item{PINER}{}
#'    \item{HESH}{}
#'    \item{KWAK}{}
#'  }
#' @source
#'  Peeples, M. A., & Schachner, G. (2012). Refining correspondence
#'  analysis-based ceramic seriation of regional data sets. \emph{Journal of
#'  Archaeological Science}, 39(8), 2818-2827.
#'  DOI: \href{https://doi.org/10.1016/j.jas.2012.04.040}{10.1016/j.jas.2012.04.040}.
"zuni"

#' Mississippi ceramics
#'
#' A dataset containing ceramic counts from the Mississippi region.
#' @format A numeric matrix with 20 rows and 10 variables:
#'  \describe{
#'    \item{ParkinPunctate}{}
#'    \item{BartonKentMPI}{}
#'    \item{Painted}{}
#'    \item{FortuneNoded}{}
#'    \item{RanchIncised}{}
#'    \item{WallsEngraved}{}
#'    \item{WallaceIncised}{}
#'    \item{RhodesIncised}{}
#'    \item{VernonPaulApplique}{}
#'    \item{HullEngraved}{}
#'  }
#' @source
#' Lipo, C. P., Madsen, M. E. & Dunnell, R. C. (2015). A
#' Theoretically-Sufficient and Computationally-Practical Technique for
#' Deterministic Frequency Seriation. \emph{PLOS ONE}, 10(4), e0124942.
#' DOI: \href{https://doi.org/10.1371/journal.pone.0124942}{10.1371/journal.pone.0124942}.
"mississippi"
