% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/notes.R
\name{note-summaries}
\alias{note-summaries}
\alias{tally_notes}
\alias{tally_pitches}
\alias{octaves}
\alias{tally_octaves}
\alias{distinct_notes}
\alias{distinct_pitches}
\alias{distinct_octaves}
\alias{pitch_range}
\alias{semitone_range}
\alias{semitone_span}
\alias{octave_range}
\alias{octave_span}
\title{Noteworthy string summaries}
\usage{
tally_notes(notes, rests = FALSE)

tally_pitches(notes, rests = FALSE)

octaves(notes)

tally_octaves(notes)

distinct_notes(notes, rests = FALSE)

distinct_pitches(notes, rests = FALSE)

distinct_octaves(notes)

pitch_range(notes)

semitone_range(notes)

semitone_span(notes)

octave_range(notes)

octave_span(notes)
}
\arguments{
\item{notes}{character, a noteworthy string, space-delimited or vector of
individual entries.}

\item{rests}{logical, include rests \code{r} and silent rests \code{s} in tally.}
}
\value{
varies by function
}
\description{
Basic summary functions for noteworthy strings.
}
\details{
These functions provide basic summaries of noteworthy strings.

Returned object depends on the nature of the function. It can be integers,
logical, character. Results can be a vector of equal length of a single
value summary.

Use the \verb{tally_*} and \verb{distinct_*} functions specifically for summaries of
unique elements.

\code{distinct_notes()} and \code{distinct_pitches()} filter a noteworthy string
to its unique elements, respectively. These functions return another
noteworthy string.

\verb{*_span} functions are just the size of a range, e.g., \code{semitone_range()} and
\code{semitone_span()}.
}
\examples{
x <- "r s e_2 a_, c#f#a#"
tally_notes(x)
tally_pitches(x)
octaves(x)
tally_octaves(x)
distinct_notes(x)
distinct_pitches(x)
distinct_octaves(x)

pitch_range(x)
semitone_range(x)
semitone_span(x)
octave_range(x)
octave_span(x)
}
\seealso{
\code{\link[=note-checks]{note-checks()}}, \code{\link[=note-metadata]{note-metadata()}}, \code{\link[=note-coerce]{note-coerce()}}, \code{\link[=valid-notes]{valid-notes()}}
}
