% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_methods.R
\name{tabr-c}
\alias{tabr-c}
\alias{c.noteworthy}
\alias{c.noteinfo}
\alias{c.music}
\alias{c.lyrics}
\alias{c.phrase}
\title{Concatenate for tabr classes}
\usage{
\method{c}{noteworthy}(...)

\method{c}{noteinfo}(...)

\method{c}{music}(...)

\method{c}{lyrics}(...)

\method{c}{phrase}(...)
}
\arguments{
\item{...}{objects.}
}
\description{
Several methods are implemented for the classes \code{noteworthy},
\code{noteinfo}, and \code{music}. See \code{\link{tabr-methods}} for
more details on methods for tabr classes.
}
\examples{
# noteworthy class examples
x <- "a b c"
c(x, x)
c(as_noteworthy(x), x)

# noteinfo class examples
x <- "4- t8( t8)( t8) 4*2"
c(as_noteinfo(x), x)

# music class examples
x <- "c,~4 c,1 c'e_'g'4-.*2"
c(as_music(x), x)

# phrase class examples
c(phrase(x), x)
}
\seealso{
\code{\link{tabr-methods}}, \code{\link{note-metadata}}
}
