% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/notes.R
\name{note_is_natural}
\alias{note_is_natural}
\alias{note_is_accidental}
\alias{note_is_flat}
\alias{note_is_sharp}
\alias{naturalize}
\alias{sharpen_flat}
\alias{flatten_sharp}
\alias{note_set_key}
\alias{as_tick_octaves}
\alias{as_integer_octaves}
\alias{as_space_time}
\alias{as_vector_time}
\alias{pretty_notes}
\title{Inspect or coerce noteworthy string formats}
\usage{
note_is_natural(notes)

note_is_accidental(notes)

note_is_flat(notes)

note_is_sharp(notes)

naturalize(notes, type = c("both", "flat", "sharp"),
  ignore_octave = FALSE)

sharpen_flat(notes, ignore_octave = FALSE)

flatten_sharp(notes, ignore_octave = FALSE)

note_set_key(notes, key = "c")

as_tick_octaves(notes)

as_integer_octaves(notes)

as_space_time(notes)

as_vector_time(notes)

pretty_notes(notes, ignore_octave = TRUE)
}
\arguments{
\item{notes}{character, a noteworthy string, space-delimited or vector of
individual entries.}

\item{type}{character, type of note to naturalize.}

\item{ignore_octave}{logical, strip any octave notation that may be present,
returning only the basic notes without explicit pitch.}

\item{key}{character, key signature to coerce any accidentals to the
appropriate form for the key. May also specify \code{"sharp"} or
\code{"flat"}.}
}
\value{
character
}
\description{
Helper functions for inspecting and setting formatting attributes of
noteworthy strings including representation of timesteps, octaves and
accidentals.
}
\details{
The \code{note_is_*} functions strictly allow individual notes, not chords.
The other functions listed here accept any noteworthy string including those
containing chords.

For \code{sharpen_flat} and \code{flatten_sharp}, sharpening flats and
flattening sharps refer to inverting their respective notation,
not to raising or lowering a flatted or sharped note by one semitone.
For the latter, use \code{naturalize}, which removes flat and/or sharp
notation from a string.
\code{note_set_key} is used for coercing a noteworthy string to a specific
and consistent notation for accidentals based on a key signature.
This is a wrapper around \code{sharpen_flat} and \code{flatten_sharp}.
\code{as_tick_octaves}, \code{as_integer_octaves}, \code{as_space_time} and
\code{as_vector_time} similarly affect octave and timestep format.
For simultaneous control over the representation of timesteps, octave
numbering and accidentals, all three are available as arguments to
\code{\link{as_noteworthy}}.
}
\examples{
x <- "a_2 a a#'"
note_is_natural(x)
note_is_accidental(x)
note_is_flat(x)
note_is_sharp(x)

x <- "e_2 a_, b_, c#f#a# c#'f#'a#''"
note_set_key(x, "f")
note_set_key(x, "g")
as_tick_octaves(x)
as_integer_octaves(x)
y <- as_vector_time(x)
is_vector_time(y)
is_space_time(as_space_time(y))

naturalize(x)
naturalize(x, "sharp")
sharpen_flat(x)
flatten_sharp(x)
pretty_notes(x)
}
